#include <iostream>
 #include <fstream>
 #include <vector>
 
 using namespace std;
 
 bool fit(const int r, const int c, const int omino_r, const int omino_c)
 {
     //cout << "( " <<  r << " , " << c << " ) - ( " << omino_r << " , " << omino_c << " ) --> " << ((r >= omino_r) && ( c >= omino_c)) << endl;
     return (r >= omino_r) && ( c >= omino_c);
 }
 
 bool omino_fit(const int case_id, const int x, const int r, const int c)
 {
     int size = r * c;
     if (size % x != 0)
     {
         return false;
     }
     for(int om_r = x; om_r > (x / 2); om_r--)
     {
         //cout << ">> " << endl;
         bool fit_1 = fit(r, c, om_r, x - om_r + 1);
         bool fit_2 = fit(r, c, x - om_r + 1, om_r);
         if(!fit_1 && !fit_2)
         {
             return false;
         }
     }
     return true;
 }
 
 int main(int argc, char** argv)
 {
     if(argc != 2)
     {
         cerr << "invalid args" << endl;
         return -1;
     }
     ifstream file(argv[1]);
     if(!file.good())
     {
         cerr << "invalid file" << endl;
         return -2;
     }
     int cases;
     file >> cases;
     for(int i = 0; i < cases; i++)
     {
         int x, r, c;
         file >> x;
         file >> r;
         file >> c;
         cout << "Case #" << (i + 1) << ": " << (omino_fit(i + 1, x, r, c) ? "GABRIEL":"RICHARD") << endl;
     }
     return 0;
 }
