#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <sys/types.h>
 #include <math.h>
 
 #define MAX_T 64
 #define MAX_X 4
 #define MAX_R 4
 #define MAX_C 4
 
 #define GABRIEL 0
 #define RICHARD 1
 
 #define BUF_SIZE 128
 
 typedef struct _testCase {
   int X;
   int R;
   int C;
 } testCase;
 
 typedef struct _testCases {
   int T;
   testCase Tarr[MAX_T];
 } testCases;
 
 testCases tc;
 int soluce[MAX_T];
 
 void parse(char* filename)
 {
   FILE* f = fopen(filename, "r");
   char buffer[BUF_SIZE];
 
   /* T */
   fgets(buffer, BUF_SIZE, f);
   tc.T = atoi(buffer);
 
   /* data */
   int i;
   for(i=0; i<tc.T; i++){
     fgets(buffer, BUF_SIZE, f);
     sscanf(buffer, "%d %d %d", &(tc.Tarr[i].X), &(tc.Tarr[i].R),
 	   &(tc.Tarr[i].C));
   }
 }
 
 int minAB(int a, int b){
   return (a<b) ? a : b;
 }
 
 int resolveCase(int caseNumber)
 {
   int X = tc.Tarr[caseNumber].X;
   int R = tc.Tarr[caseNumber].R;
   int C = tc.Tarr[caseNumber].C;
   int min = minAB(R,C);
 
   /* 1. nombre de cases invalide */
   if( (R*C) % X )
     return RICHARD;
 
   /* 2. X-omino trop gros pour la table */
   if( (X/2) > min)
     return RICHARD;
 
   /* 3. coin vide possible ? */
   if( X >= (min+2) )
     return RICHARD;
   
   /* 4. Si X >= 8, est-ce qu'on peut rajouter une case
    au centre et toujours pouvoir placer le machin ? */
   /*
   if( X >= 7 ){
     if( (X+1)/2 > R || (X+1)/2 > C)
       return RICHARD;
   }
   */ 
   return GABRIEL;
 }
 
 int main(int argc, char** argv)
 {
   parse(argv[1]);
 
   int i;
   for(i=0; i<tc.T; i++)
     soluce[i] = resolveCase(i);
 
   for(i=0; i<tc.T; i++)
     printf("case #%d: %s\n", i+1, ((soluce[i]) ? "RICHARD" : "GABRIEL"));
 
   return EXIT_SUCCESS;
 }
