#include <stdio.h>
 #include <string.h>
 #include <limits.h>
 
 #define FOR(i, a, b) for (i = (a); i < (b); ++i)
 #define REP(i, n) FOR(i, 0, n)
 
 int cmpfunc (const void * a, const void * b){
 	//qsort(values, 5, sizeof(int), cmpfunc);
 	return ( *(int*)a - *(int*)b );
 }
 
 void solve(int t){
 	int n,q;
 	scanf("%d%d",&n,&q);
 	int horses[n][2];
 	int i,j;
 	REP(i,n){
 		scanf("%d%d",&horses[i][0],&horses[i][1]);
 	}
 
 	int graph[n][n];
 	REP(i,n){
 		REP(j,n){
 			scanf("%d",&graph[i][j]);
 		}
 	}
 
 	long dist[n];
 	dist[0] = 0;
 	for(i = 1;i < n;i++){
 		dist[i] = dist[i-1] + graph[i-1][i];
 	}
 
 	printf("Case #%d: ",t);	
 	REP(i,q){
 		int u,v;
 		scanf("%d%d",&u,&v);
 
 		int currentDest = n-1;
 		double time = 0;
 		while(currentDest != 0){
 			// printf("\n%d\n",currentDest);
 			double minTime = INT_MAX;
 			int minIndex = currentDest-1;
 			for(j = currentDest-1;j >= 0;j--){
 				if(horses[j][0] >= dist[currentDest]-dist[j]){
 					double newTime = (double)(dist[currentDest]-dist[minIndex])/horses[j][1];
 					// printf("| %d %0.6lf | ",j,newTime);
 					if(newTime < minTime){
 						minTime = newTime + (double)(dist[minIndex]-dist[j])/horses[j][1];
 						minIndex = j;
 					}
 				}
 			}
 			currentDest = minIndex;
 			time += minTime;
 		}
 
 		printf("%0.6lf\n",time);
 	}
 }
 
 int main(){
 	int T,t;
 	scanf("%d",&T);
 	for(t = 1;t <= T;t++){
 		solve(t);
 	}
 }