#include <cstdio>
 #include <algorithm>
 
 using namespace std;
 
 #define NMAX 100
 #define EMAX 1000000000
 #define SMAX 1000
 #define DMAX 1000000000
 
 struct Horse {
     int e;
     int s;
 };
 
 int main()
 {
     int t;
     static int dist[NMAX][NMAX];    /// dist[i][j] - distance from i to j (directed)
     //static double time[NMAX][NMAX];
     static double tmin[NMAX];
     static Horse h[NMAX];
 
     scanf("%d", &t);
     for (int tc = 1; tc <= t; ++tc) {
         int n, q;
 
         scanf("%d %d", &n, &q);
 
         for (int i = 0; i < n; ++i) {
             scanf("%d %d", &h[i].e, &h[i].s);
         }
 
         for (int i = 0; i < n; ++i) {
             for (int j = 0; j < n; ++j) {
                 scanf("%d", &dist[i][j]);
             }
         }
 
         /// compute minimum times with one horse
         /*for (int i = 0; i < n; ++i) {
             fill(time[i], time[i]+n, numeric_limits<double>::infinity());
         }*/
 
         printf("Case #%d:", tc);
         for (int p = 0; p < q; ++p) {
             int start, dest;
 
             scanf("%d %d", &start, &dest);
             --start;
             --dest;
 
             /// find shortest time to get from start to dest
             /// small dataset: only path from first to last city
             tmin[0] = 0.0;
             fill(tmin+1, tmin+n, numeric_limits<double>::infinity());
             for (int i = 0; i < n-1; ++i) {
                 /// using horse h[i]
                 int dist_left = h[i].e;
                 for (int j = i+1; j < n; ++j) {
                     if (dist_left < dist[j-1][j]) {
                         break;
                     }
 
                     double t = (double)dist[j-1][j]/h[i].s;
                     tmin[j] = min(tmin[j], tmin[j-1]+t);
                     dist_left -= dist[j-1][j];
                 }
             }
 
             printf(" %f", tmin[n-1]);
         }
 
         printf("\n");
     }
 
     return 0;
 }
