#include <iostream>
 #include <vector>
 #include <algorithm>
 #include <cmath>
 #include <cstdlib>
 #include <unordered_map>
 #include <string>
 #include <utility>
 #include <unordered_set>
 #include <queue>
 using namespace std;
 
 typedef pair<int, int> ii;
 typedef pair<float, float> ff;
 typedef vector<int> vi;
 
 typedef vector<float> vf;
 typedef vector<ff> vff;
 
 typedef vector<ii> vii;
 #define INF 1000000000
 
 int main() {
 	int t;
 	cin >> t;
 	double ret = 0;
 	for (int test = 0; test < t; test++) {
 		int n,q;
 		cin >> n >> q;
 		int V = n;
 		vector < pair < int, int> > horses;
 
 		int graph[V][V];
 		vector< vector< ff > > AdjList;
 		AdjList.assign(V, vff());
   for (int i = 0; i < V; i++) {
     for (int j = 0; j < V; j++)
       graph[i][j] = INF;
     graph[i][i] = 0;
   }
 		vector < ii > pairsToCompare;
 
 		int distances[n][n]; // distance from i to j
 		for (int i=0; i < n; i++) {
 			int e,s;
 			cin >> e >> s; 
 			horses.push_back(make_pair(e,s)); // first is distance, second is speed
 		}
 		for (int i=0; i < n; i++) {
 			for (int j=0; j < n; j++) {
 				int distance;
 				cin >> distance;
 				if (distance != -1) {
 					graph[i][j] = distance;
 				}
 			}
 		}
 		for (int i=0; i < q; i++) {
 			int s,d;
 			cin >> s >> d;
 			pairsToCompare.push_back(ii(s-1,d-1));
 		}
 
 		 for (int k = 0; k < V; k++) // common error: remember that loop order is k->i->j
     for (int i = 0; i < V; i++)
       for (int j = 0; j < V; j++)
         graph[i][j] = min(graph[i][j], graph[i][k] + graph[k][j]);
 
  //for (int i = 0; i < V; i++)
    //   for (int j = 0; j < V; j++)
     //	cout << "these are the current constraints: city " << i << " to city " << j << " weight " << graph[i][j] << endl; 
 
     	//MakeEdgesForEachHorse();
     	for (int i=0; i < horses.size(); i++) {
     		for (int j = 0; j < V; j++) {
     			if (graph[i][j] <= horses[i].first) {
     				float time = (float) graph[i][j] / (float) horses[i].second;
     				AdjList[i].push_back(ff(j, time));
     			}
     		}
     	}
     	for (int i=0; i < AdjList.size(); i++) {
     		for (int j=0; j < AdjList[i].size(); j++) {
     			//cout << "these are the current constraints: city " << i << " to city " << AdjList[i][j].first << " weight " << AdjList[i][j].second << endl; 
     		}
     	}
 		cout << "Case #" << test+1 << ": ";
 		//calculateShortestPathFrom(i,j);
 		for (int i=0; i < q; i++) {
 			int s = pairsToCompare[i].first;
 
 			vector < float> dist(V, INF); dist[s] = 0;                    // INF = 1B to avoid overflow
   priority_queue< pair<float,float>, vector< pair<float,float> >, greater< pair <float, float> > > pq; pq.push(ff(0, s));
                              // ^to sort the pairs by increasing distance from s
   while (!pq.empty()) {                                             // main loop
     ff front = pq.top(); pq.pop();     // greedy: pick shortest unvisited vertex
     float d = front.first, u = front.second;
     if (d > dist[u]) continue;   // this check is important, see the explanation
     for (int j = 0; j < (int)AdjList[u].size(); j++) {
       ff v = AdjList[u][j];                       // all outgoing edges from u
       if (dist[u] + v.second < dist[v.first]) {
         dist[v.first] = dist[u] + v.second;                 // relax operation
         pq.push(ff(dist[v.first], v.first));
   } } }  // note: this variant can cause duplicate items in the priority queue
 		cout.precision(6);
   		cout << fixed << dist[pairsToCompare[i].second] << " ";
 		}
 
 		cout << endl;
 	}
 	return 0;
 }