#include <iostream>
 #include <cstdio>
 #include <cstdlib>
 #include <vector>
 #include <set>
 #include <map>
 #include <list>
 #include <algorithm>
 #include <cmath>
 #include <string>
 #include <unordered_set>
 #include <unordered_map>
 
 using namespace std;
 
 typedef long long ll;
 typedef unsigned long long ull;
 typedef vector<int> vec;
 typedef vector<ll> vecll;
 
 const int MaxN = 1000 * 1000 + 10;
 const ll mod = 1000 * 1000 * 1000 + 7;
 const int INF = 1000000000;
 
 vector<int> Dejjecstra(int startVertex, const vector<vector<pair<int, int>>> & g) {
     int s = startVertex;
     int n = static_cast<int>(g.size());
     vector<int> d(n, INF);
     d[s] = 0;
     set < pair<int,int> > q;
     q.insert (make_pair (d[s], s));
     while (!q.empty()) {
         int v = q.begin()->second;
         q.erase (q.begin());
 
         for (size_t j=0; j<g[v].size(); ++j) {
             int to = g[v][j].first,
                     len = g[v][j].second;
             if (d[v] + len < d[to]) {
                 q.erase (make_pair (d[to], to));
                 d[to] = d[v] + len;
                 q.insert (make_pair (d[to], to));
             }
         }
     }
     return d;
 }
 
 vector<vector<double>> CreateGraph(const vector<vector<pair<int, int>>> & g,
                                    const vector<double> & dist, const vector<double> & speeds) {
     int n = (int)g.size();
     vector<vector<double>> newGraph(n);
     // cout << "\n*************\n";
     for (int i = 0; i < n; ++i) {
         vector<int> d = Dejjecstra(i, g);
         vector<double> currD(n);
         for (int j = 0; j < n; ++j) {
             if (d[j] > dist[i]) {
                 currD[j] = INF; // из и города до йотого добраться нельзя
             } else {
                 currD[j] = (double)d[j] / speeds[i];
             }
         }
         newGraph[i] = currD;
         /*cout << speeds[i] << " : ";
         for (int j = 0; j < n; ++j) {
             cout << d[j] << " ";
         }
         cout << endl;*/
     }
     // cout << "\n*************\n";
     return newGraph;
 }
 
 vector<vector<double>> Floid(vector<vector<double>> d) {
     int n = (int)d.size();
     for (int k=0; k<n; ++k)
         for (int i=0; i<n; ++i)
             for (int j=0; j<n; ++j)
                 if (d[i][k] < INF && d[k][j] < INF)
                     d[i][j] = min (d[i][j], d[i][k] + d[k][j]);
     return d;
 }
 
 int main() {
     std::ios_base::sync_with_stdio(false);
     std::cin.tie(nullptr);
     // freopen("in.txt", "r", stdin);
     // freopen("out.txt", "w", stdout);
     // ifstream cin("in.txt");
     // ofstream cout("out.txt");
     int cntTest;
     cin >> cntTest;
     cout.precision(30);
     for (int test = 0; test < cntTest; ++test) {
 
         int n, Q;
         cin >> n >> Q;
         vector<double> dist(n), speeds(n);
         for (int i = 0; i < n; ++i) {
             cin >> dist[i] >> speeds[i];
         }
         vector<vector<pair<int, int>>> g(n);
         for (int i = 0; i < n; ++i) {
             for (int j = 0; j < n; ++j) {
                 int w;
                 cin >> w;
                 if (w != -1) {
                     g[i].push_back({j, w});
                 }
             }
         }
 
         /*for (int i = 0; i < n; ++i) {
             cout << i << " : ";
             for (int j = 0; j < g[i].size(); ++j) {
                 cout << "( "<< g[i][j].first << " " << g[i][j].second << ") ";
             }
             cout << endl;
         }*/
         auto gg = CreateGraph(g, dist, speeds);
         vector<vector<double>> Times = Floid(gg);
         // Reqeests
         cout << "Case #" << test + 1 << ": ";
         for (int i = 0; i < Q; ++i) {
             int a, b;
             cin >> a >> b;
             --a;
             --b;
             cout << Times[a][b] << " ";
 
         }
         cout << endl;
     }
 
     return 0;
 }
 
 /*
  1
  3 1
 2 3
 2 4
 4 4
 -1 1 -1
 -1 -1 1
 -1 -1 -1
 1 3
  */