#include <iostream>
 #include <fstream>
 #include <vector>
 #include <climits>
 #include <iomanip>
 
 using namespace std;
 
 int main(int argc, char** argv)
 {
 	string inFile(argv[1]);
 	string outFile(inFile + ".out");
 	ifstream in(inFile);
 	ofstream out(outFile);
 
 	int ts; in >> ts;
 	for (int tt = 1; tt <= ts; ++tt)
 	{
 		int n, q; in >> n >> q;
 		double horses[n][2];
 		for (int i = 0; i < n; i++)
 		{
 			in >> horses[i][0] >> horses[i][1];
 		}
 		int graph[n][n];
 		for (int i = 0; i < n; i++)
 		{
 			for (int j = 0; j < n; j++)
 			{
 				in >> graph[i][j];
 			}
 		}
 		int s, t; in >> s >> t;
 		s--;
 		t--;
 		vector<double> dists;
 		vector<int> path;
 		int cur = s;
 		dists.push_back(0);
 		path.push_back(cur);
 		int index = 1;
 		while (cur != t)
 		{
 			for (int i = 0; i < n; i++)
 			{
 				if (graph[cur][i] > 0)
 				{
 					dists.push_back(graph[cur][i] + dists[index - 1]);
 					cur = i;
 					path.push_back(cur);
 					index++;
 					break;
 				}
 			}
 		}
 		double times[dists.size()];
 		times[0] = 0;
 		for (int i = 1; i < dists.size(); i++)
 		{
 			cout << "i = " << i << endl;
 			double mntime = INT_MAX;
 			for (int j = 0; j < i; j++)
 			{
 				double jidist = dists[i] - dists[j];
 				int horse = path[j];
 				if (horses[horse][0] >= jidist)
 				{
 					double prev = 0;
 					if (j > 0) prev = times[j];
 					mntime = min(mntime, jidist / horses[horse][1] + prev);
 					cout << "min time: " << mntime << endl;
 				}
 				cout << "j: " << j << ", jidist: " << jidist << endl;
 			}
 			double iidist = dists[i] - dists[i - 1];
 			cout << "mntime: " << mntime << ", iidist: " << iidist << endl;
 			if (horses[path[i - 1]][0] >= iidist)
 			{
 				times[i] = min(mntime, times[i - 1] + (iidist / horses[path[i - 1]][1]));
 			}
 			else
 			{
 				times[i] = mntime;
 			}
 			cout << "time: " << times[i] << endl;
 		}
 		out << "Case #" << tt << ": " << fixed << setprecision(18) << times[dists.size() - 1] << endl;
 	}
 	return 0;
 }
