#include <iostream>
 #include <string>
 #include <vector>
 #include <set>
 #include <map>
 #include <sstream>
 #include <list>
 #include <iomanip>
 
 using namespace std;
 
 template<class P0, class P1> ostream &operator<<(ostream &os, const pair<P0, P1> &p) { return os << "(" << p.first << "," << p.second << ")"; }
 template<class T> void _dump(const T &t) { cerr << "["; for (auto it = t.begin(); it != t.end(); ++it) cerr << " " << *it; cerr << " ]" << "\n"; } 
 
 #define dump(x) { cerr << #x << ": "; _dump(x); }
 #define trace(x) { cerr << #x << ": " << x << "\n"; }
 
 int main(void) {
   int T; cin >> T;
 
   for (int iCase = 1; iCase <= T; ++iCase) {
     cout << "Case #" << iCase << ":";
 
     int n, nRoutes; cin >> n >> nRoutes;
     vector<int> maxDist(n);
     vector<double> speed(n);
     for (int i = 0; i < n; ++i) cin >> maxDist[i] >> speed[i];
     vector< vector<int> > dist0(n, vector<int>(n));
     for (int i = 0; i < n; ++i) {
       for (int j = 0; j < n; ++j)
 	cin >> dist0[i][j];
       //dump(dist0[i]);
     }
 
     vector< vector<double> > noSwitchTimes(n, vector<double>(n, -1.0));
     for (int horse = 0; horse < n; ++horse) {
       vector<int> dist(n, -1);
       multimap<int, int> toDo;
 
       trace(horse);
       //dump(dist);
 
 
       toDo.insert(make_pair(0, horse));
       while (!toDo.empty()) {
 	int d0 = toDo.begin()->first;
         int i0 = toDo.begin()->second;
 	toDo.erase(toDo.begin());
 	if (dist[i0]!=-1) continue;
 	dist[i0] = d0;
 	for (int j = 0; j < n; ++j)
 	  if (dist0[i0][j] >= 0)
 	    toDo.insert(make_pair(d0 + dist0[i0][j], j));
        }
 
       // dump(dist);
 
       for (int i = 0; i < n; ++i)
 	if (dist[i] <= maxDist[horse] && dist[i] >= 0)
 	  noSwitchTimes[horse][i] = dist[i] / speed[horse];
 
       // dump(noSwitchTimes[horse]);
     }
 
     for (int iRoute = 0; iRoute < nRoutes; ++iRoute) {
       int start, finish; cin >> start >> finish; --start; --finish;
 
       vector<double> bestTimes(n, -1.0);
       multimap<double, int> toDo;
       toDo.insert(make_pair(0.0, start));
       while (!toDo.empty()) {
 	double t0 = toDo.begin()->first;
 	int i0 = toDo.begin()->second;
 	toDo.erase(toDo.begin());
 	if (bestTimes[i0]!=-1.0) continue;
 	bestTimes[i0] = t0;
 	for (int j = 0; j < n; ++j)
 	  if (noSwitchTimes[i0][j] >= 0.0)
 	    toDo.insert(make_pair(t0 + noSwitchTimes[i0][j], j));
       }
 
       cout << " " << setprecision(8) << bestTimes[finish];
     }
     
     cout << "\n";
   }
 
   return 0;
 }
