#include <iostream>
 #include <cstdio>
 #include <algorithm>
 #include <vector>
 #include <set>
 #include <queue>
 #include <cmath>
 #include <map>
 #include <cassert>
 
 using namespace std;
 
 #define MOD (1000000000000007LL)
 #define LL long long
 
 #define sqr(x) ((x) * (x))
 #define Nmax 113
 
 inline void test_out() {
     static int test_id = 0;
     test_id ++;
     cout << "Case #" << test_id << ":";
 }
 
 int n,q;
 double e[Nmax], s[Nmax];
 double dist[Nmax][Nmax];
 
 double A[Nmax][Nmax], B[Nmax][Nmax];
 
 const double MAX_INF = 1000000LL * 1000000LL * 1000LL;
 
 int main() {
     ios_base::sync_with_stdio(0);
     freopen("C-large.in", "r", stdin);
     freopen("answer.txt", "w", stdout);
 
     int test_number;
     cin >> test_number;
     while (test_number --> 0) {
         cin >> n >> q;
         //assert(q == 1);
         for (int i = 1; i <= n; i ++) {
             cin >> e[i] >> s[i];
         }
         for (int i = 1; i <= n; i ++) {
             for (int j = 1; j <= n; j ++) {
                 int x;
                 cin >> x;
                 dist[i][j] = x;
             }
         }
 
         for (int i = 1; i <= n; i ++) {
             for (int j = 1; j <= n; j ++) {
                 if (i == j) A[i][j] = 0.0;
                 else if (dist[i][j] == -1)
                         A[i][j] = MAX_INF;
                         else
                             A[i][j] = dist[i][j];
             }
         }
 
         for (int k = 1; k <= n; k ++)
             for (int i = 1; i <= n; i ++)
                 if (A[i][k] != MAX_INF)
                 for (int j = 1; j <= n; j ++) {
                     if (A[k][j] != MAX_INF)
                         A[i][j] = min(A[i][j], A[i][k] + A[k][j]);
                 }
 
         for (int i = 1; i <= n; i ++) {
             for (int j = 1; j <= n; j ++) {
                 if (dist[i][j] == -1)
                     B[i][j] = MAX_INF;
                 else
                     B[i][j] = (dist[i][j] * 1.0 / s[i]);
             }
             B[i][i] = 0.0;
         }
 
         for (int i = 1; i <= n; i ++) {
             for (int j = 1; j <= n; j ++) {
                 if (e[i] >= A[i][j])
                     B[i][j] = min(B[i][j], A[i][j] * 1.0 / s[i]);
             }
         }
 
         for (int k = 1; k <= n; k ++) {
             for (int i = 1; i <= n; i ++) {
                 if (B[i][k] != MAX_INF)
                 for (int j = 1; j <= n; j ++) {
                     if (B[k][j] != MAX_INF)
                         B[i][j] = min(B[i][j], B[i][k] + B[k][j]);
 
                 }
             }
         }
 
         test_out();
         cout.precision(9);
         for (int i = 1; i <= q; i ++) {
             int u,v;
             cin >> u >> v;
             assert(B[u][v] != MAX_INF);
             cout << " " << fixed << B[u][v];
         }
         cout << endl;
     }
     return 0;
 }
