#include <bits/stdc++.h>
 using namespace std;
 
 const int MAX_N = 105;
 
 struct State {
 	int node, horse, rem, speed;
 	double d;
 
 	State() {}
 	State(int node, int horse, int rem, int speed, double d) {
 		this->node = node;
 		this->horse = horse;
 		this->rem = rem;
 		this->speed = speed;
 		this->d = d;
 	}
 
 	bool operator< (const State &other) const {
 		return d > other.d;
 	}
 };
 
 bool visited[MAX_N][MAX_N];
 int n, a[MAX_N][MAX_N], e[MAX_N], s[MAX_N];
 double dist[MAX_N][MAX_N][MAX_N];
 
 void dijkstra(int st) {
 	priority_queue<State> pq;
 
 	pq.push(State(st, st, e[st], s[st], 0));
 	dist[st][st][st] = 0;
 
 	while(!pq.empty()) {
 		int node, horse, rem, speed;
 		double curr_d;
 
 		node = pq.top().node;
 		horse = pq.top().horse;
 		rem = pq.top().rem;
 		speed = pq.top().speed;
 		curr_d = pq.top().d;
 		
 		pq.pop();
 
 		if(visited[node][horse]) {
 			continue;
 		}
 		visited[node][horse] = true;
 
 		for(int i = 1; i <= n; i++) {
 			if(!visited[i][horse] && a[node][i] != -1) {
 				if(a[node][i] <= rem && (dist[st][i][horse] == -1 || dist[st][i][horse] > curr_d + a[node][i] / (double) speed)) {
 					dist[st][i][horse] = curr_d + a[node][i] / (double) speed;
 					pq.push(State(i, horse, rem - a[node][i], speed, dist[st][i][horse]));
 				}
 			}
 			if(!visited[i][node] && a[node][i] != -1) {
 				if(dist[st][i][node] == -1 || dist[st][i][node] > curr_d + a[node][i] / (double) s[node]) {
 					dist[st][i][node] = curr_d + a[node][i] / (double) s[node];
 					pq.push(State(i, node, e[node] - a[node][i], s[node], dist[st][i][node]));
 				}
 			}
 		}
 	}
 }
 
 int main() {
 	int cnt_tests;
 	scanf("%d", &cnt_tests);
 
 	for(int cs = 1; cs <= cnt_tests; cs++) {
 		int q;
 		scanf("%d%d", &n, &q);
 		
 		for(int i = 1; i <= n; i++) {
 			scanf("%d%d", &e[i], &s[i]);
 		}
 
 		for(int i = 1; i <= n; i++) {
 			for(int j = 1; j <= n; j++) {
 				scanf("%d", &a[i][j]);
 			}
 		}
 		
 		for(int i = 1; i <= n; i++) {
 			for(int j = 1; j <= n; j++) {
 				for(int p = 1; p <= n; p++) {
 					dist[i][j][p] = -1;
 				}
 			}
 		}
 
 		for(int i = 1; i <= n; i++) {
 			memset(visited, 0, sizeof(visited));
 			dijkstra(i);
 		}
 
 		/**
 		for(int i = 1; i <= n; i++) {
 			for(int j = 1; j <= n; j++) {
 				for(int p = 1; p <= n; p++) {
 					printf("i: %d, j: %d, p: %d, cost: %f\n", i, j, p, dist[i][j][p]);
 				}
 			}
 		}
 		*/
 
 		printf("Case #%d:", cs);
 		for(int i = 0; i < q; i++) {
 			int x, y;
 			scanf("%d%d", &x, &y);
 			
 			double ans = -1;
 			for(int j = 1; j <= n; j++) {
 				if(ans == -1 || (dist[x][y][j] < ans && dist[x][y][j] != -1)) {
 					ans = dist[x][y][j];
 				}
 			}
 
 			printf(" %f", ans);
 		}
 		printf("\n");
 	}
 
 	return 0;
 }
