﻿#include <algorithm>
 #include <cassert>
 #include <cstring>
 #include <deque>
 #include <iomanip>
 #include <iostream>
 #include <numeric>
 #include <set>
 #include <string>
 #include <vector>
 
 const double inf = 1e18;
 const double max_d = 1e15;
 
 long long d[110][110];
 int e[110];
 int s[110];
 
 double dp[110];
 
 struct cmp {
     bool operator()(int i, int j) const {
         if (dp[i] != dp[j]) {
             return dp[i] < dp[j];
         }
         return i < j;
     }
 };
 
 int main() {
     // std::freopen("C:/Users/Admin/Documents/Visual Studio 2015/Projects/hackerrank/Debug/in.txt", "r", stdin);
     // std::freopen("C:/Users/Admin/Documents/Visual Studio 2015/Projects/hackerrank/Debug/out.txt", "w", stdout);
 
     int tn;
     std::cin >> tn;
 
     for (int ti = 1; ti <= tn; ++ti) {
         int n;
         std::cin >> n;
 
         int q;
         std::cin >> q;
 
         for (int i = 1; i <= n; ++i) {
             std::cin >> e[i] >> s[i];
         }
 
         for (int i = 1; i <= n; ++i) {
             for (int j = 1; j <= n; ++j) {
                 std::cin >> d[i][j];
                 if (i == j) {
                    // d[i][j] = 0;
                 } else if (d[i][j] == -1) {
                    // d[i][j] = max_d;
                 }
             }
         }
 
         for (int k = 1; k <= n; ++k) {
             for (int i = 1; i <= n; ++i) {
                 for (int j = 1; j <= n; ++j) {
                     if (d[i][k] == -1 || d[k][j] == -1) {
                         continue;
                     }
                     auto tot_d = d[i][k] + d[k][j];
                     if (d[i][j] == -1 || d[i][j] > tot_d) {
                         d[i][j] = tot_d;
                     }
                 }
             }
         }
 
         std::vector<double> answers;
         for (int qi = 1; qi <= q; ++qi) {
             int u, v;
             std::cin >> u >> v;
 
             for (int i = 1; i <= n; ++i) {
                 dp[i] = inf;
             }
 
             dp[u] = 0;
 
             std::set<int, cmp> set;
             for (int i = 1; i <= n; ++i) {
                 set.insert(i);
             }
 
             while (!set.empty()) {
                 int next_u = *set.begin();
                 set.erase(next_u);
 
                 for (int j = 1; j <= n; ++j) {
                     auto tot_d = d[next_u][j];
                     if (j == next_u) {
                         continue;
                     }
                     if (tot_d == -1) {
                         continue;
                     }
                     if (e[next_u] < tot_d) {
                         continue;
                     }
                     double t = (double)(tot_d) / s[next_u] + dp[next_u];
                     if (dp[j] > t) {
                         set.erase(j);
                         dp[j] = t;
                         set.insert(j);
                     }
                 }
             }
 
             double answer = dp[v];
             assert(answer < inf);
             answers.push_back(answer);
         }
 
         std::cout << "Case #" << ti << ": ";
         for (int i = 0; i < q; ++i) {
             auto answer = answers[i];
             std::cout << std::fixed << std::setprecision(10) << answer << std::endl;
         }
     }
 }