#define _CRT_SECURE_NO_DEPRECATE
 #include <iostream>
 #include <string>
 #include <vector>
 #include <sstream>
 #include <queue>
 #include <algorithm>
 #include <iomanip>
 #include <map>
 #include <set>
 #include <math.h>
 #include <stack>
 #include <deque>
 #include <numeric>
 #include <cstring>
 #include <cstdio>
 #include <cstdlib>
 #include <bitset>
 #include <functional>
 #define all(x) x.begin(),x.end()
 #define mpair make_pair
 using namespace std;
 typedef long long ll;
 typedef long double ld;
 const ld epsylon = 1e-9;
 
 const string PROGRAM_NAME = "google";
 ll mod =1000000007;
 int r, c, d;
 vector<pair<int, int> > nonzero;
 
 bool check_possible(const vector<vector<ll> >& a) {
   for (int i = 0; i < (int)nonzero.size(); ++i) {
     for (int j = i + 1; j < (int)nonzero.size(); ++j) {
       ll dx = abs(nonzero[i].first - nonzero[j].first);
       ll dy = abs(nonzero[i].second - nonzero[j].second);
       ll diff = abs(a[nonzero[i].first][nonzero[i].second] -
           a[nonzero[j].first][nonzero[j].second]);
       if (diff > (dx + dy) * d) {
         return false;
       }
     }
   }
   return true;
 }
 int main() {
   freopen((PROGRAM_NAME + ".in").c_str(), "r", stdin);
   freopen((PROGRAM_NAME + ".out").c_str(), "w", stdout);
   int nt;
   cin >> nt;
   for (int it = 1; it <= nt; it++) {
     cerr << "Processing case " << it << endl;
     int n;
     cin >> r >> c >> n >> d;
     vector<vector<ll> > a(r, vector<ll>(c, 0));
     nonzero.clear();
     for (int i = 0; i < n; ++i) {
       int x, y, b;
       cin >> x >> y >> b;
       nonzero.push_back(mpair(x - 1, y - 1));
       a[x - 1][y - 1] = b;
     }
     cout << "Case #" << it << ": ";
     if (!check_possible(a)) {
       cout << "IMPOSSIBLE\n";
       continue;
     }
 
     bool possible = true;
     for (int i = 0; i < r && possible; ++i) {
       for (int j = 0; j < c && possible; ++j) {
         if (a[i][j] != 0) {
           continue;
         }
         ll low = -(1LL<<60);
         ll high = 1LL << 60;
         for (int r = 0; r < (int)nonzero.size(); ++r) {
           ll dx = abs(nonzero[r].first - i);
           ll dy = abs(nonzero[r].second - j);
           ll val = a[nonzero[r].first][nonzero[r].second];
           low = max(low, val - d * (dx + dy));
           high = min(high, val + d * (dx + dy));
         }
         if (high < low) {
           possible = false;
           break;
         }
         a[i][j] = high;
         nonzero.push_back(mpair(i, j));
       }
     }
     if (!possible) {
       cout << "IMPOSSIBLE\n";
       continue;
     }
 
     ll sum = 0;
     for (int i = 0; i < r; ++i) {
         for (int j = 0; j < c; ++j) {
           sum = (sum + a[i][j]) % mod;
         }
     }
     cout << sum << endl;
   }
   return 0;
 }
