#include <iostream>
 #include <vector>
 #include <queue>
 #include <tuple>
 
 using namespace std;
 
 typedef long long int64;
 
 const int64 kInf = (1LL<<60);
 const int kMod = 1e9+7;
 
 int n, r, c, D;
 bool valid(int x, int y) {
 	return 1 <= x && x <= r && 1 <= y && y <= c;
 }
 
 vector<pair<int,int>> dir = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
 
 void Solve() {
 	cin >> r >> c >> n >> D;
 
 	queue<pair<int,int>> Q;
 	vector<vector<bool>> inq(r+1, vector<bool>(c+1));
 	vector<vector<int64>> d(r+1, vector<int64>(c+1));
 	vector<vector<int64>> init(r+1, vector<int64>(c+1));
 
 	for (int i = 1; i <= r; ++i) {
 		for (int j = 1; j <= c; ++j) {
 			d[i][j] = init[i][j] = kInf;
 		}
 	}
 
 	for (int i = 1; i <= n; ++i) {
 		int x, y, b;
 		cin >> x >> y >> b;
 		d[x][y] = init[x][y] = b;
 		Q.push({x, y});
 		inq[x][y] = true;
 	}
 
 	while (!Q.empty()) {
 		int x, y;
 		tie(x, y) = Q.front();
 		
 		for (auto vec : dir) {
 			int xx = x + vec.first;
 			int yy = y + vec.second;
 
 			if (valid(xx, yy) && d[xx][yy] > d[x][y] + D) {
 				d[xx][yy] = d[x][y] + D;
 				if (!inq[xx][yy]) {
 					Q.push({xx, yy});
 					inq[xx][yy] = true;
 				}
 			}
 		}
 		Q.pop();
 		inq[x][y] = false;
 	}
 
 	int64 ans = 0;
 
 	for (int i = 1; i <= r; ++i) {
 		for (int j = 1; j <= c; ++j) {
 			if (init[i][j] != kInf && d[i][j] != init[i][j]) {
 				cout << "IMPOSSIBLE";
 				return;
 			}
 			ans = (ans + d[i][j]) % kMod;
 		}
 	}
 
 	cout << ans;
 }
 
 int main() {
 	freopen("test", "r", stdin);
 	freopen("out", "w", stdout);
 	int tests;
 	cin >> tests;
 
 	for (int k = 1; k <= tests; ++k) {
 		cout << "Case #" << k << ": ";
 		Solve();
 		cout << "\n";
 	}
 }