#include <cstdio>
 #include <iostream>
 #include <vector>
 #include <cmath>
 #include <algorithm>
 #include <string>
 #include <set>
 #include <map>
 #include <ctime>
 #include <cstring>
 #include <cassert>
 #include <bitset>
 #include <sstream>
 #include <queue>
 
 #define pb push_back
 #define mp make_pair
 #define fs first
 #define sc second
 #define sz(a) ((int) (a).size())
 #define eprintf(...) fprintf(stderr, __VA_ARGS__)
 
 using namespace std;
 
 typedef long long int64;
 typedef long double ldb;
 
 const long double eps = 1e-9;
 const int inf = (1 << 30) - 1;
 const long long inf64 = ((long long)1 << 62) - 1;
 const long double pi = acos(-1);
 
 template <class T> T sqr (T x) {return x * x;}
 template <class T> T abs (T x) {return x < 0 ? -x : x;}
 
 const int P = 1000 * 1000 * 1000 + 7;
 
 int main () {
     ios_base::sync_with_stdio(0);
 	freopen("input.txt", "rt", stdin);
 	freopen("output.txt", "wt", stdout);
 
     int tc;
 	cin >> tc;
 	for (int ti = 0; ti < tc; ++ti) {
 	    int n, m, k, d;
 	    cin >> n >> m >> k >> d;
 
 	    vector<vector<int>> a(n, vector<int>(m, -1));
 		for (int i = 0; i < k; ++i) {
 			int x, y, w;
 			cin >> x >> y >> w;
 
 			--x, --y;
 			a[x][y] = w;
 		}
 
 		vector<vector<long long>> max_val(n, vector<long long>(m, inf64));
 		for (int x1 = 0; x1 < n; ++x1) {
 			for (int y1 = 0; y1 < m; ++y1) {
 				if (a[x1][y1] != -1) {
 					for (int x2 = 0; x2 < n; ++x2) {
 						for (int y2 = 0; y2 < m; ++y2) {
 							int len = abs(x1 - x2) + abs(y1 - y2);
 							max_val[x2][y2] = min(max_val[x2][y2], a[x1][y1] + len * (long long) d);
 						}
 					}
 				}
 			}
 		}
 
 		bool key = true;
 		for (int i = 0; i < n; ++i) {
 			for (int j = 0; j < m; ++j) {
 				if (a[i][j] != -1 && a[i][j] > max_val[i][j]) {
 					key = false;
 				}
 			}
 		}
 
 		if (!key) {
 			cout << "Case #" << ti + 1 << ": IMPOSSIBLE" << endl;
 			continue;
 		}
 
 		long long res = 0;
 		for (int i = 0; i < n; ++i) {
 			for (int j = 0; j < m; ++j) {
 				res += max_val[i][j] % P;
 			}
 	   	}
 
 	   	res %= P;
 	   	cout << "Case #" << ti + 1 << ": " << res << endl;
 	}
 
 
 	return 0;
 }
