#include <iostream>
 #include <vector>
 #include <string>
 #include <set>
 #include <map>
 #include <algorithm>
 #include <list>
 #include <math.h>
 #include <time.h>
 typedef long long ll;
 typedef long double ld;
 using namespace std;
 
 const ll SZ = 1e3 + 10;
 const ll INF = 1e18;
 const ll MOD = 1e9 + 7;
 
 ll r, c, n, d, mx[SZ][SZ];
 bool mkd[SZ][SZ];
 
 int main() {
 	freopen("input.txt", "r", stdin);
 	freopen("output.txt", "w", stdout);
 
 	ll ts;
 	cin >> ts;
 
 	for (ll testno = 1; testno <= ts; testno++) {
 		cin >> r >> c >> n >> d;
 
 		for (ll i = 0; i < r; i++)
 			for (ll j = 0; j < c; j++) {
 				mx[i][j] = INF;
 				mkd[i][j] = false;
 			}
 
 		vector<pair<ll, pair<ll, ll> > > q;
 		for (ll i = 0; i < n; i++) {
 			ll a, b, c;
 			cin >> a >> b >> c;
 			q.push_back(make_pair(c, make_pair(a - 1, b - 1)));
 		}
 		sort(q.rbegin(), q.rend());
 
 		bool ok = true;
 		for (auto i : q) {
 			ll x = i.second.first,
 				y = i.second.second,
 				z = i.first;
 
 			for (ll j = 0; j < r; j++)
 				for (ll k = 0; k < c; k++) {
 					ll val = ll(abs(j - x) + abs(k - y)) * d + z;
 					if (mkd[j][k] && val < mx[j][k])
 						ok = false;
 					mx[j][k] = min(mx[j][k], val);
 				}
 			mkd[x][y] = true;
 		}
 		
 		ll sum = 0;
 		for (ll i = 0; i < r; i++)
 			for (ll j = 0; j < c; j++)
 				sum += mx[i][j];
 
 		cout << "Case #" << testno << ": ";
 		if (ok)
 			cout << sum % MOD;
 		else
 			cout << "IMPOSSIBLE";
 		cout << "\n";
 	}
 
 	return 0;
 }