#include <bits/stdc++.h>
 
 using namespace std;
 
 struct Field {
     int r, c;
     long long b;
     bool operator<(const Field& other) const {
         return b > other.b;
     }
 };
 
 const long long MOD = 1000000007;
 
 int main() {
     ifstream in("input.txt");
     ofstream out("output.txt");
     cin.rdbuf(in.rdbuf());
     cout.rdbuf(out.rdbuf());
     int T;
     cin >> T;
     for (int test = 1; test <= T; test++) {
         int r, c, n;
         long long d;
         cin >> r >> c >> n >> d;
         vector<vector<long long>> canvas(r, vector<long long>(c, 0));
         priority_queue<Field> prio;
         for (int i = 0; i < n; ++i) {
             int r, c, b;
             cin >> r >> c >> b;
             canvas[r - 1][c - 1] = b;
             prio.push({ r - 1, c - 1, b });
         }
         while(!prio.empty()) {
             Field f = prio.top();
             prio.pop();
             if (f.r > 0 && canvas[f.r - 1][f.c] == 0) {
                 canvas[f.r - 1][f.c] = f.b + d;
                 prio.push({ f.r - 1, f.c, f.b + d });
             }
             if (f.r < r - 1 && canvas[f.r + 1][f.c] == 0) {
                 canvas[f.r + 1][f.c] = f.b + d;
                 prio.push({ f.r + 1, f.c, f.b + d });
             }
             if (f.c > 0 && canvas[f.r][f.c - 1] == 0) {
                 canvas[f.r][f.c - 1] = f.b + d;
                 prio.push({ f.r, f.c - 1, f.b + d });
             }
             if (f.c < c - 1 && canvas[f.r][f.c + 1] == 0) {
                 canvas[f.r][f.c + 1] = f.b + d;
                 prio.push({ f.r, f.c + 1, f.b + d });
             }
         }
         long long sum = 0;
         bool valid = true;
         for (int i = 0; i < r && valid; ++i) {
             for (int j = 0; j < c && valid; ++j) {
                 sum = (sum + canvas[i][j]) % MOD;
                 if (i && abs(canvas[i][j] - canvas[i - 1][j]) > d)
                     valid = false;
                 if (j && abs(canvas[i][j] - canvas[i][j - 1]) > d)
                     valid = false;
             }
         }
         cout << "Case #" << test << ": " << (valid ? to_string(sum) : "IMPOSSIBLE") << endl;
     }
 }