//#define _CRT_SECURE_NO_WARNINGS
 //#include <Windows.h>
 
 #include <map>
 #include <string>
 #include <stdio.h>
 #include <vector>
 #include <sstream>
 #include <stack>
 #include <bitset>
 #include <set>
 #include <unordered_map>
 #include <unordered_set>
 #include <queue>
 #include <iostream>
 #include <algorithm>
 #include <limits.h>
 #include <float.h>
 
 
 using namespace std;
 
 
 
 bool isValid(int& value, int target){
 	double dbV = value;
 	double lb = 0.9 * target;
 	double ub = 1.1 * target;
 	return (dbV >= lb && dbV <= ub);
 }
 
 
 bool findTime(vector<vector<int>>& quants, vector<int>& ings, int time, vector<vector<bool>>& isVis){
 	int n(quants.size());
 	vector<int> cands;
 	for (int i = 0; i < n; i++){
 		int lb = 0.9 * ings[i] * time;
 		int ub = 1.1 * ings[i] * time;
 		auto cand = lower_bound(quants[i].begin(), quants[i].end(), lb);
 		bool foundId = false;
 		while (cand != quants[i].end() && *cand <= ub){
 			if (*cand < lb)
 				cand++;
 			else{
 				if (!isVis[i][cand - quants[i].begin()]){
 					cands.push_back(cand - quants[i].begin());
 					foundId = true;
 					break;
 				}
 				else cand++;
 			}
 		}
 		if (!foundId) return false;
 	}
 	for (int i = 0; i < n; i++){
 		isVis[i][cands[i]] = true;
 	}
 	return true;
 }
 
 int main(){
 	//freopen("B-small-attempt0.in", "r", stdin);
 	//freopen("result.txt", "w", stdout);
 	
 	int t;
 	cin >> t;
 
 	for (int k = 1; k <= t; k++){
 		int n, p;
 		cin >> n >> p;
 		vector<int> ings(n, 0);
 		for (int i = 0; i < n; i++)
 			cin >> ings[i];
 
 
 		vector<vector<int>> quants(n, vector<int>(p, 0));
 		for (int i = 0; i < n; i++){
 			for (int j = 0; j < p; j++){
 				cin >> quants[i][j];
 			}
 			sort(quants[i].begin(), quants[i].end());
 		}
 
 		int res = 0;
 
 		vector<vector<bool>> isVis(n, vector<bool>(p, false));
 		
 		for (int j = 0; j < p; j++){
 			if (isVis[0][j]) continue;
 			int minTime = quants[0][j] / ings[0];
 			if (minTime > 1) minTime--;
 
 			if (isValid(quants[0][j], ings[0] * minTime)){
 				if (findTime(quants, ings, minTime, isVis)) 
 					res++;
 			}
 			minTime++;
 			if (isValid(quants[0][j], ings[0] * minTime))
 				if (findTime(quants, ings, minTime, isVis))
 					res++;
 			minTime++;
 			if (isValid(quants[0][j], ings[0] * minTime))
 			if (findTime(quants, ings, minTime, isVis))
 				res++;
 		}
 		printf("Case #%d: %d\n", k, res);
 	}
 
 
 	
 }
