#include <iostream>
 #include <iomanip>
 #include <cstring>
 #include <string>
 #include <vector>
 #include <algorithm>
 
 #define INF 1000000000
 
 using namespace std;
 
 using ullong = unsigned long long;
 using llong = long long;
 
 void getBounds(int q, int s, int& left, int& right)
 {
     int s1 = s * 110;
     int s2 = s * 90;
     left = (q * 100) / s1;
     right = (q * 100) / s2;
 
     vector<int> v;
     for (int i=90; i<=110; ++i)
     {
         if ((q * 100) % (s * i) == 0)
             v.push_back((q*100) / (s*i));
     }
 
     if (v.size() == 1)
     {
         left = v[0];
         right = v[0];
     }
     else if (v.size() > 1)
     {
         left = v[0];
         right = v[v.size()-1];
     }
 }
 
 int main()
 {
     int t;
     cin >> t;
     for (int tidx = 1; tidx <= t; ++tidx)
     {
         int n, p;
         int i, j, k;
         cin >> n >> p;
 
         vector<int> r(n);
         vector<vector<int>> q(n);
         for (i=0; i<n; ++i)
             cin >> r[i];
 
         for (i=0; i<n; ++i) {
             q[i].resize(p, 0);
 
             for (j=0; j<p; ++j)
                 cin >> q[i][j];
         }
 
         for (i=0; i<n; ++i)
             sort(q[i].begin(), q[i].end());
 
         vector<int> left(n, -1);
         vector<int> right(n, -1);
         vector<bool> used(n);
         int count = 0;
         for (i=0; i<p; ++i)
         {
             getBounds(q[0][i], r[0], left[0], right[0]);
 
             if (n > 1)
             {
                 for (k=1; k<=1; ++k)
                 {
                     for (j=0; j<p; ++j)
                     {
                         if (used[j])
                             continue;
 
                         getBounds(q[k][j], r[k], left[k], right[k]);
                         if ((left[k] <= left[0] && left[0] <= right[k]) ||
                             (left[k] <= right[0] && right[0] <= right[k]))
                         {
                             ++count;
                             used[k] = true;
                             break;
                         }
                     }
                 }
             }
             else if (right[0] > 0)
                 ++count;
         }
 
         cout << "Case #" << tidx << ": ";
         cout << count;
         cout << endl;
     }
     return 0;
 }
