#include <vector>
 #include <queue>
 #include <iostream>
 #include <string>
 #include <algorithm>
 
 using namespace std;
 
 struct Worker {
 	vector<int> ms;
 };
 
 struct Machine {
 	vector<int> ws;
 };
 
 struct Graph {
 	vector<Worker> ws;
 	vector<Machine> ms;
 };
 
 struct SubGraph {
 	vector<int> workers;
 	vector<int> machines;
 };
 
 int startCost(const Graph &g, const SubGraph &subg) {
 	int n = subg.machines.size();
 	int sum = 0;
 	for (const auto &w : subg.workers)
 		sum += n - g.ws[w].ms.size();
 	return sum;
 }
 
 vector<SubGraph> conc(const Graph &graph) {
 	vector<SubGraph> ans;
 	{
 		std::vector<bool> seen(graph.ws.size(), false);
 		queue<int> wq;
 		for (int firstW = 0; firstW < graph.ws.size(); firstW++) {
 			if (seen[firstW])
 				continue;
 			wq.push(firstW);
 			SubGraph subg;
 			while (!wq.empty()) {
 				int w = wq.front();
 				wq.pop();
 				if (seen[w])
 					continue;
 				seen[w] = true;
 				for (int m : graph.ws[w].ms)
 					for (int w2 : graph.ms[m].ws)
 							wq.push(w2);
 				subg.workers.push_back(w);
 			}
 			ans.push_back(subg);
 		}
 	}
 	{
 		vector<bool> seen(graph.ms.size(), false);
 		for (auto &g : ans) {
 			for (int w : g.workers)
 				for (int m : graph.ws[w].ms)
 					if (!seen[m]) {
 						g.machines.push_back(m);
 						seen[m] = true;
 					}
 		}
 		for (int i = 0; i < seen.size(); i++)
 			if (!seen[i])
 				ans.push_back({ {}, {i} });
 	}
 
 	return ans;
 }
 
 struct SubgSize {
 	int w, m;
 };
 bool operator==(SubgSize a, SubgSize b) {
 	return a.w == b.w && a.m == b.m;
 }
 
 typedef vector<SubgSize>::const_iterator SubIt;
 
 void simplify(vector<SubgSize> &v, int &cost) {
 	int w1c = 0;
 	int m1c = 0;
 	const SubgSize w1 = { 1, 0 };
 	const SubgSize m1 = { 0, 1 };
 	vector<SubgSize> v2;
 	for (const auto &i : v) {
 		if (i == w1)
 			w1c++;
 		else if (i == m1)
 			m1c++;
 		else
 			v2.push_back(i);
 	}
 	int m = std::min(w1c, m1c);
 	w1c -= m;
 	m1c -= m;
 	for (int i = 0; i < w1c; i++)
 		v2.push_back(w1);
 	for (int i = 0; i < m1c; i++)
 		v2.push_back(m1);
 	swap(v, v2);
 	cost += m;
 }
 
 int run(SubgSize current, const vector<SubgSize> &subgs, vector<bool> &left, int i) {
 	if (i == left.size()) {
 		if (current.m != current.w)
 			return 100000;
 		for (int i = 0; i < left.size(); i++)
 			if (left[i])
 				return run({ 0,0 }, subgs, left, 0);
 		return 0;
 	}
 	if (current.m == current.w) {
 		current.m = 0;
 		current.w = 0;
 	}
 	int best = 100000;
 	for (int next = i; next < left.size(); next++) {
 		if (left[next]) {
 			int cost = subgs[next].w*current.m + subgs[next].m*current.w;
 			left[next] = 0;
 			cost += run({ current.w + subgs[next].w, current.m + subgs[next].m }, subgs, left, next + 1);
 			if (cost < best)
 				best = cost;
 			left[next] = 1;
 		}
 	}
 	return best;
 }
 
 int main() {
 	int T;
 	cin >> T;
 	for (int i = 1; i <= T; i++) {
 		int n;
 		cin >> n;
 		Graph g;
 		g.ms.resize(n);
 		g.ws.resize(n);
 		string s;
 		for (int i = 0; i < n; i++) {
 			cin >> s;
 			for (int j=0; j<n; j++)
 				if (s[j]=='1') {
 					g.ws[i].ms.push_back(j);
 					g.ms[j].ws.push_back(i);
 				}
 		}
 		vector<SubGraph> subgs = conc(g);
 		int cost = 0;
 		vector<SubgSize> subgss(subgs.size());
 		for (int i = 0; i < subgs.size(); i++) {
 			subgss[i].m = subgs[i].machines.size();
 			subgss[i].w = subgs[i].workers.size();
 			cost += startCost(g, subgs[i]);
 		}
 		vector<bool> left(subgss.size(), true);
 		cost += run({ 0, 0 }, subgss, left, 0);
 		cout << "Case #" << i << ": " << cost << endl;
 	}
 	return 0;
 }
