#include <iostream> 
 #include <string>
 #include <vector>
 
 using namespace std;
 
 int sizeOfPancakeFlipper;
 int firstNumber;
 
 int minNumberOfFlips(int sumToMake, int numberOfFlips) {
 	int minNumber = numberOfFlips + sumToMake;
 	bool minFlipsChanged = false;
 
 	for(int i = sizeOfPancakeFlipper; i >= firstNumber; i = i-2) {
 		int flipNumber;
 		if (sumToMake >= 2*i) {
 			flipNumber = minNumberOfFlips(sumToMake - 2*i, numberOfFlips + 1); 
 		} else if (sumToMake == 0) {
 			flipNumber = numberOfFlips;
 		} else {
 			flipNumber = -1;
 		}	
 		if (flipNumber != -1 && flipNumber <= minNumber) {
 			minFlipsChanged = true;
 			minNumber = flipNumber;
 		}
 	}
 	if (minFlipsChanged) {
 		return minNumber;
 	} else {
 		return -1;
 	}
 }
 
 int main(int argc, char *argv[]) {
 
 	int numberOfTestCases;
 	vector <string> results; 
 
 	cin>>numberOfTestCases;
 
 	for(int i = 0; i <numberOfTestCases; i++) {
 
 		string pancakeString;
 
 		cin>>pancakeString;
 		cin>>sizeOfPancakeFlipper;
 
 		int j = 0;
 		int countOfNeg = 0;
 		while(pancakeString[j] != '\0') {
 			if (pancakeString[j] == '-') {
 				countOfNeg++;
 			}
 			j++;
 		}
 
 		int sumToMake = 2*countOfNeg;
 
         firstNumber = sizeOfPancakeFlipper%2 == 0 ? 2 : 1;
 
 		int setsOfFlips = minNumberOfFlips(sumToMake, 0);
 
 		if (setsOfFlips == -1) {
 			results.push_back("IMPOSSIBLE");
 		} else {
 			std::string result = std::to_string(setsOfFlips);
 			results.push_back(result);
 		}
 
 	}
 
 	for(int i = 0; i < numberOfTestCases; i++) {
 		cout<<"Case #"<<i+1<<": "<<results[i]<<endl;
 	}	
 
 	return 0;
 }