#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 
 void readCakes(char maximum[], char destination[], int cakesNum){
     int i;
     for(i=0; i<cakesNum; i++){
         destination[i] = maximum[i];
     }
 }
 
 int getCakesNum(char cakes[]){
     int i=0;
     while(cakes[i] == '+' || cakes[i] == '-'){
         i++;
     }
     return i+1;
 }
 
 int needFlips(char cakes[], int cakesNum){
     int i;
     for(i=0; i < cakesNum; i++){
         if (cakes[i] == '-'){
             return 1;
         }
     }
     return 0;
 }
 
 int countBlankSide(char cakes[], int cakesNum){
     int count = 0;
     int i;
     for(i=0; i < cakesNum; i++){
         if (cakes[i] == '-'){
             count++;
         }
     }
     return count;
 }
 
 int startRightFrom(char cakes[], int cakesNum){
     int i;
     for(i=0; i<cakesNum; i++){
         if (cakes[i] == '-'){
             return i;
         }
     }
 }
 
 int startLeftFrom(char cakes[], int cakesNum){
     int i;
     for(i=cakesNum-1; i >= 0; i--){
         if (cakes[i] == '-'){
             return i;
         }
     }
 }
 
 void rightFlip(char cakes[], int cakesNum, int k, int flipIndex){
     int i;
     for(i=0; i<k; i++){
         if (cakes[flipIndex] == '+'){
             cakes[flipIndex] = '-';
         }else{
             cakes[flipIndex] = '+';
         }
         flipIndex++;
     }
 }
 
 void leftFlip(char cakes[], int cakesNum, int k, int flipIndex){
     int i;
     for(i=0; i<k; i++){
         if (cakes[flipIndex] == '+'){
             cakes[flipIndex] = '-';
         }else{
             cakes[flipIndex] = '+';
         }
         flipIndex--;
     }
 }
 
 int main()
 {
     FILE *file;
     FILE *outputFile;
     file = fopen("A-large.in","r");
     outputFile = fopen("output.txt","w");
     char maxCakes[1001];
     int t, k, cakesNum, minimumFlips, test = 0, flag = 0, flipIndex;
 
     fscanf(file,"%d",&t);
     while(test < t){
         fscanf(file,"%s %d",&maxCakes, &k);
         cakesNum = getCakesNum(maxCakes);
         char cakes[cakesNum];
         readCakes(maxCakes, cakes, cakesNum);
         char tempLeft[cakesNum];
         char tempRight[cakesNum];
         minimumFlips = 0;
         flag = 1;
         while (needFlips(cakes, cakesNum)){
             if (minimumFlips%2 == 0){
                     flipIndex = startRightFrom(cakes, cakesNum);
                     if(flipIndex+k >= cakesNum){
                         flag = 0;
                         break;
                     }
                     strcpy(tempRight,cakes);
                     rightFlip(cakes, cakesNum, k, flipIndex);
                     if(!strcmp(tempLeft,cakes)){
                         flag = 0;
                         break;
                     }
                 }else{
                     flipIndex = startLeftFrom(cakes, cakesNum);
                     if(flipIndex-k < 0){
                         flag = 0;
                         break;
                     }
                     strcpy(tempLeft,cakes);
                     leftFlip(cakes, cakesNum, k, flipIndex);
                     if(!strcmp(tempLeft,cakes)){
                         flag = 0;
                         break;
                     }
                 }
                 minimumFlips++;
         }
         if(flag == 1){
             fprintf(outputFile,"Case #%d: %d",test+1, minimumFlips);
         }else{
             fprintf(outputFile,"Case #%d: IMPOSSIBLE",test+1);
         }
         test++;
         if(test != t){
             fprintf(outputFile,"\n");
         }
     }
     fclose(file);
     return 0;
 }
