#include <stdio.h>
 
 #define BIT_MAX 10000
 
 int bit_table[BIT_MAX];
 
 void bit_init(void) {
 	int i;
 	for (i = 0; i <BIT_MAX; i++) bit_table[i] = 0;
 }
 
 void bit_add(int pos,int value) {
 	pos++;
 	while (pos <= BIT_MAX) {
 		bit_table[pos - 1] += value;
 		pos += pos & (-pos);
 	}
 }
 
 int bit_sum(int pos) {
 	int sum = 0;
 	pos++;
 	while (pos > 0) {
 		sum += bit_table[pos - 1];
 		pos -= pos & (-pos);
 	}
 	return sum;
 }
 
 /* flip [start, end) */
 void bit_flip(int start, int end) {
 	bit_add(start, 1);
 	bit_add(end, -1);
 }
 
 /* return side[pos] : 0=happy side, 1=blank side */
 int bit_get(int pos) {
 	return (bit_sum(pos) - bit_sum(pos - 1)) % 2;
 }
 
 int main(void) {
 	int T;
 	int case_count;
 	if (scanf("%d", &T) != 1) return 1;
 	for (case_count = 1; case_count <= T; case_count++) {
 		char S[1024];
 		int K;
 		int length;
 		int i;
 		int count = 0;
 		int is_ok = 1;
 		if (scanf("%1023s%d", S, &K) != 2) return 1;
 		/* initialize board */
 		bit_init();
 		for (i = 0; S[i] != '\0'; i++) {
 			if (S[i] == '-') bit_flip(i, i + 1);
 		}
 		length = i;
 		/* flip from left to right whenever required */
 		for (i = 0; i + K <= length; i++) {
 			if (bit_get(i)) {
 				bit_flip(i, i + K);
 				count++;
 			}
 		}
 		/* check if it is done */
 		for (i = 0; i < length; i++) {
 			if (bit_get(i)) {
 				/* blank side found! */
 				is_ok = 0;
 				break;
 			}
 		}
 		printf("Case #%d: ", case_count);
 		if (is_ok) {
 			printf("%d\n", count);
 		} else {
 			puts("IMPOSSIBLE");
 		}
 	}
 	return 0;
 }
