#include <stdio.h>
 #include <string.h>
 
 #define LINE_BUF 1024
 
 int
 isAllFlipped(char *start, char *end) {
     while (start <= end) {
         if (*start == '-') {
             return 0;
         }
         start++;
     }
     return 1;
 }
 
 int
 getFlipCount(char *start, char *end, int k, int flip) {
     if (*start == '-') {
         flip++;
         for (int i = 0; i < k; i++) {
             *(start + i) = *(start +i) == '+' ? '-' : '+'; 
         }
     }
     if (*end == '-') {
         flip++;
         for (int i = 0; i < k; i++) {
             *(end - i) = *(end - i) == '+' ? '-' : '+';
         }
     }
 
     if (end-start-1 < k) {
         if (isAllFlipped(start, end)) {
             return flip;
         } else {
             return -1;
         }
     }
     return getFlipCount(start+1, end-1, k, flip);
 }
 
 int
 main(int argc, char* argv[]) {
     FILE *ifp;
     FILE *ofp;
     if (argc != 2) {
         printf("usage: problem_a input.txt\n");
         return 1;
     }
 
     char outfile[LINE_BUF];
     strcpy(outfile, argv[1]);
     strcpy(strchr(outfile, '.'), ".out");
     printf("filename: %s, outfile: %s\n", argv[1], outfile);
 
     ifp = (FILE *) fopen(argv[1], "r");
     ofp = (FILE *) fopen(outfile, "w");
 
     int count, k, result;
     char s[1001];
     
     fscanf(ifp, "%d", &count);
     for (int i=0; i<count; i++) {
         fscanf(ifp, "%s %d", s, &k);
 
         result = getFlipCount(s, s+strlen(s)-1, k, 0);
 
         fprintf(ofp, "Case #%d: ", (i+1));
         printf("Case #%d: ", (i+1));
         if (result < 0) {
             fprintf(ofp, "IMPOSSIBLE");
             printf("IMPOSSIBLE");
         } else {
             fprintf(ofp, "%d", result);
             printf("%d", result);
         }
         fprintf(ofp, "\n");
         printf("\n");
     }
 
     fclose(ifp);
     fclose(ofp);
 
     return 0;
 }
 
