#include <stdio.h>
 #include <string.h>
 
 #define S_SIZE 1001
 
 char s[S_SIZE];
 
 int all_happy(char *s) {
 	int len = strlen(s);
 	int i;
 
 	for (i = 0; i < len; i++) {
 		if (s[i] == '-')
 			return 0;
 	}
 	return 1;
 }
 
 void flip (char *s, int start, int k) {
 	int i;
 	
 	for (i = start; i < start+k; i++) {
 		if (s[i] == '-') {
 			s[i] = '+';
 		} else if (s[i] == '+') {
 			s[i] = '-';
 		} else {
 			fprintf(stderr, "should not be %c\n", s[i]);
 		} 
 	}
 }
 int main(int argc, char **argv) {
 	if (argc != 2) {
 		fprintf(stderr, "Wrong number of arguments\nUsage : %s input\n", argv[0]);
 		return 1;
 	}
 
 	FILE *f = fopen(argv[1], "r");
 	int nr_cases;
 	int i, k;
 	int j, cpt;
 	if (f == NULL) {
 		perror("fopen");
 		return 1;
 	}
 	fscanf(f, "%d", &nr_cases);
 
 	for (i = 0; i < nr_cases; i++) {
 		fscanf(f, "%s", &s);
 		fscanf(f, "%d", &k);
 		if (all_happy(s)) {
 			printf("Case #%d: 0\n", i+1);
 			continue;
 		}
 
 		cpt = 0;
 		for (j = 0; j <= strlen(s) - k; j++) {
 			if (s[j] == '-') {
 				flip(s,j,k);
 				cpt++;
 			}
 		}
 		
 		if (all_happy(s)) {
 			printf("Case #%d: %d\n", i+1, cpt);
 		} else {
 			printf("Case #%d: IMPOSSIBLE\n", i+1);
 		}
 	}
 	 
 	return 0;
 }
