#include <stdint.h>
 #include <stdio.h>
 #include <string.h>
 
 static void print_bits(int8_t *bits, int len)
 {
     for (int i = 0; i < len; i += 1)
         printf("%c", bits[i] ? '+' : '-');
     printf("\n");
 }
 
 int main (int argc, char * argv[])
 {
     int t;
     scanf("%d", &t);
 
     for (int i = 0; i < t; i += 1) {
         char s[1024];
         int k;
         scanf("%s %d", s, &k);
 
         // Convert '+' and '-' to 1 and 0
         int len = strlen(s);
         int8_t bits[1024];
         for (int j = 0; j < len; j += 1)
             bits[j] = (s[j] == '+') ? 1 : 0;
 
         // Doesn't matter what order we flip (XOR), so go left-to-right
         // At each offset we can either flip zero or one time
         // We have to flip at position j if it's face down, otherwise
         //  no future flips will change position j
         int nflips = 0;
         for (int j = 0; j <= len-k; j += 1) {
             if (!bits[j]) {
                 for (int l = 0; l < k; l += 1) {
                     bits[j+l] = !bits[j+l];
                 }
                 nflips += 1;
             }
         }
 
         int complete = 1;
         for (int j = 0; j < len; j += 1) {
             if (!bits[j]) {
                 complete = 0;
                 break;
             }
         }
 
         printf("Case #%d: ", i+1);
         if (complete)
             printf("%d\n", nflips);
         else
             printf("IMPOSSIBLE\n");
     }
 }
