#include <stdio.h>
 #include <string.h>
 #include <stdlib.h>
 
 #define NDEBUG			1
 #include <assert.h>
 
 #define RES_BAD			1
 #define RES_OK			0
 
 #if NDEBUG
 #	define dbg_printf(...)	((void)0)
 #else
 #	define dbg_printf(...)	printf(__VA_ARGS__) /* variadic macro, C99 */
 #endif
 
 #define MAX_LEN			1001
 
 int solve(FILE *f, char *result)
 {
 	int scanned;
 	char s[MAX_LEN] = { 0, };
 	size_t k;
 	size_t l = 0;
 	size_t i = 0;
 	size_t j = 0;
 	int res = 0;
 
 	scanned = fscanf(f, "%s %zu", s, &k);
 	if (scanned != 2) {
 		printf("Parsing failed\n");
 		return RES_BAD;
 	}
 
 	l = strlen(s);
 
 	dbg_printf("s: %s, l %zu, k: %zu\n", s, l, k);
 
 	for (i = 0; i < l; i++) {
 		dbg_printf("loop %zu\n", i);
 
 		if (s[i] == '+')
 			continue;
 
 		dbg_printf("flip\n");
 		res++;
 
 		for (j = 0; j < k; j++) {
 			if (s[i + j] == '+') {
 				s[i + j] = '-';
 			} else if (s[i + j] == '-') {
 				s[i + j] = '+';
 			} else {
 				dbg_printf("can't do it!\n");
 				sprintf(result, "IMPOSSIBLE");
 				return RES_OK;
 			}
 		}
 	}
 
 	dbg_printf("done with %d flips\n", res);
 	sprintf(result, "%d", res);
 
 	return RES_OK;
 }
 
 int main(void)
 {
 	FILE *file_in, *file_out;
 	char result[MAX_LEN] = { 0 };
 	int cases, a_case;
 	int scanned;
 
 	file_in = fopen("in.txt", "r");
 	file_out = fopen("out.txt", "w");
 
 	if (!file_in || !file_out)
 	{
 		printf("Bad i/o file\n");
 		return RES_BAD;
 	}
 
 	scanned = fscanf(file_in, "%d", &cases);
 	if (scanned != 1) {
 		printf("Reading number of cases failed\n");
 		return RES_BAD;
 	} else {
 		printf("Solving %d cases... \n", cases);
 	}
 
 	for (a_case = 0; a_case < cases; a_case++)
 	{
 		if (solve(file_in, result) == RES_BAD) {
 			printf("Solving failed!\n");
 			return RES_BAD;
 		}
 		fprintf(file_out, "Case #%d: %s\n", a_case + 1, result);
 	}
 
 	fclose(file_in);
 	fclose(file_out);
 
 	printf("Done!\n");
 
 	return RES_OK;
 }
