#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #define S 1000
 
 void flip(char *pancakes, size_t flipper)
 {
 	size_t i;
 
 	for(i = 0; i < flipper; i++)
 		pancakes[i] ^= '+' ^ '-';
 }
 
 int solve(char *pancakes, size_t flipper)
 {
 	size_t i;
 	size_t count;
 	size_t size;
 
 	count = 0;
 	size  = strlen(pancakes);
 
 	/* Every pancakes before i are in good position, don't touch them */
 	for(i = 0; i <= size - flipper; i++)
 		if(pancakes[i] == '-') {
 			flip(&pancakes[i], flipper);
 			count++;
 		}
 
 	/* Ensure remaining pancakes are flipped */
 	for(i = i; i < size; i++)
 		if(pancakes[i] == '-')
 			return -1;
 
 	return count;
 }
 
 int main(int argc, char *argv[])
 {
 	size_t i, n;
 
 	char   pancakes[S + 1];
 	size_t flipper;
 	int    ret;
 
 	scanf("%u", &n);
 
 	for(i = 0; i < n; i++) {
 		/* Reader gets a bonus point if they can exploit this BoF */
 		scanf("%s %d", pancakes, &flipper);
 
 		printf("Case #%d: ", i + 1);
 
 		ret = solve(pancakes, flipper);
 
 		if(ret >= 0)
 			printf("%d\n", ret);
 		else
 			puts("IMPOSSIBLE");
 	}
 
 }