#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 
 #define MAX_LENGTH 1000
 
 void print_status(char *buf, int num_pancakes) {
     for (int i = 0; i < num_pancakes; i++) {
         putchar(buf[i]);
     }
     printf(" ");
 }
 
 int calc_min(char *buf, int num_pancakes, int spatula_width) {
     if (num_pancakes <= spatula_width) {
         int num_up = 0, num_down = 0;
         for (int i = 0; i < num_pancakes; i++) {
             if (buf[i] == '+') {
                 num_up++;
             } else {
                 num_down++;
             }
         }
 
         if (num_up == num_pancakes) {
             return 0;
         } else if (num_down == num_pancakes) {
             return 1;
         } else {
             return -1;
         }
     }
 
     if (buf[0] == '+') {
         return calc_min(buf+1, num_pancakes-1, spatula_width);
     }
 
     // flip them!
     for (int i = 0; i < spatula_width; i++) {
         buf[i] = buf[i] == '-' ? '+' : '-';
     }
 
     int right_min = calc_min(buf+1, num_pancakes-1, spatula_width);
 
     if (right_min < 0) {
         return -1;
     }
 
     return 1 + right_min;
 }
 
 int main(int argc, char *argv[]) {
     if (argc < 2) {
         printf("Usage: %s <input-file>\n", argv[0]);
         exit(1);
     }
 
     FILE *fp;
     fp = fopen(argv[1], "r");
 
     int num_examples;
     fscanf(fp, "%d", &num_examples);
 
     for (int i = 0; i < num_examples; i++) {
         printf("Case #%d: ", i+1);
         int spatula_width;
         int num_pancakes;
         char buf[MAX_LENGTH + 1];
         fscanf(fp, "%s %d", buf, &spatula_width);
 
         num_pancakes = strlen(buf);
         int num_flips = calc_min(buf, num_pancakes, spatula_width);
         if (num_flips < 0) {
             printf("IMPOSSIBLE\n");
         } else {
             printf("%d\n", num_flips);
         }
     }
 
     fclose(fp);
 }
