#include <stdio.h>
 #include <string.h>
 
 int flipsCount(char* pancakes, int flipWidth);
 int main() {
 	int nTestcases, tc = 1;
 	char pancakes[1001]; //max 1000 pancakes
 	int flipWidth, flips;
 
 	scanf("%d", &nTestcases);
 	for(tc = 1; tc <= nTestcases; ++tc) {
 		scanf("%s", pancakes);
 		scanf("%d", &flipWidth);
 		flips = flipsCount(pancakes, flipWidth);
 		if(flips < 0) {
 			printf("Case #%d: IMPOSSIBLE\n", tc);
 		} else { 
 			printf("Case #%d: %d\n", tc, flips);
 		}
 	}
 	return 0;
 }
 
 int flipsCount(char* pancakes, int flipWidth) {
 	int n = strlen(pancakes);
 	int i, j, flips = 0;
 
 	//There are "n - flipWidth + 1" substrings of length flipWidth.
 	//Make sure the first char of each of them is a "happy side".
 	//That way, we'll be left with only the last "flipWidth - 1" pancakes.
 	//If any one of them doesn't have a "happy side", it's IMPOSSIBLE.
 	for(i = 0; i <= n - flipWidth; ++i) {
 		if(pancakes[i] == '-') { //flip from the leftmost "blank side"
 			++flips;
 			for(j = i; j < i + flipWidth; ++j) {
 				pancakes[j] = (pancakes[j] == '+') ? '-' : '+';
 			}
 		}
 	}
 
 	//except for the last flipWidth-1 pancakes, we are sure all are with "happy side".
 	for(i = n - flipWidth; i < n; ++i) {
 		if(pancakes[i] == '-') return -1;
 	}
 	return flips;
 }
