#include <iostream>
 #include <string>
 #include <map>
 #include <vector>
 // #include <list>
 // #include <pair>
 #include <set>
 #include <queue>
 
 using namespace std;
 
 class Node {
 	vector<int> vec;
 	int depth;
 public:
 	Node(vector<int> _vec, int d) {
 		vec = _vec;
 		depth = d;
 	}
 
 	vector<int> getState() const {
 		return vec;
 	}
 	
 	int getDepth() const {
 		return depth;
 	}
 
 	bool operator==(Node b) {
 		if(vec.size() != b.vec.size())
 			return false;
 		for(int i =0, len = vec.size(); i < len; ++i) {
 			if(vec[i] != b.vec[i])
 				return false;
 		}
 		return true;
 	}
 	
 	bool operator<(const Node b) const {
 		return depth > b.depth;
 	}
 };
 
 class comp
 {
 public:
 	comp() {}
 	bool operator() (const Node& lhs, const Node& rhs) const
 	{
 		return lhs.getDepth() > lhs.getDepth();
 	}
 };
 
 typedef std::priority_queue<Node,std::vector<Node>,comp> mypq_type;
 
 int solve_A(vector<int> vec, int k);
 bool solve_A_aux(vector<int> vec, int k, int dep);
 bool is_finished(vector<int> vec);
 string vec_to_str(vector<int> vec);
 bool check_impossible(vector<int> vec, int k);
 
 vector<Node> open_node(Node &node, int k);
 int solve_A_2(vector<int> vec, int k);
 
 map<string, bool> hash;
 
 int main() {
 	int len;
 	vector<pair<vector<int>, int> > in;
 	
 	cin >> len;
 	for (int i = 1; i <= len; ++i) {
 		int k;
 		string str;
 		
 		cin >> str >> k;
 		vector<int> vec;
 		for(auto &s: str) {
 			if(s == '+') {
 				vec.push_back(1);
 			} else if(s == '-') {
 				vec.push_back(-1);
 			}
 		}
 		in.push_back(pair<vector<int>, int>(vec, k) );
 	}
 	
 	for (int i = 0; i < len; ++i) {
 		int sol = solve_A_2(in[i].first, in[i].second);
 		if(sol == -1) {
 			cout << "Case #" << i + 1 << ": IMPOSSIBLE";
 		} else {
 			cout << "Case #" << i + 1<< ": " << sol;
 		}
 		if(i != len - 1)
 			cout << endl;
 	}
 	
 	return 0;
 }
 
 int solve_A(vector<int> vec, int k) {
 	for(int i = 0; i < 100; i++) {
 		::hash.clear();
 		bool ret = solve_A_aux(vec, k, i);
 		if(ret)
 			return i;
 	}
 	return -1;
 }
 
 bool solve_A_aux(vector<int> vec, int k, int dep) {
 	if(::hash.find(vec_to_str(vec)) != ::hash.end()) {
 		return false;
 	}
 	::hash[vec_to_str(vec)] = true;
 	if(dep < 0) {
 		return false;
 	}
 	if(is_finished(vec))
 		return true;
 	
 	for(int i = 0; i <= vec.size() - k; i++) {
 		vector<int> new_vec = vec;
 		for(int j = i; j < i + k; j++) {
 			new_vec[j] *= -1;
 		}
 		if (solve_A_aux(new_vec, k, dep - 1))
 			return true;
 	}
 	return false;
 }
 
 bool is_finished(vector<int> vec) {
 	for(auto it: vec) {
 		if(it == -1){
 			return false;
 		}
 	}
 	return true;
 }
 
 string vec_to_str(vector<int> vec) {
 	string str;
 	for(auto &it: vec) {
 		if (it == -1) {
 			str += "0";
 		} else if (it == 1) {
 			str += "1";
 		}
 	}
 	return str;
 }
 
 vector<Node> open_node(Node &node, int k)
 {
 	vector<Node> res;
 	for(int i = 0, len = node.getState().size() - k; i <= len; i++) {
 		vector<int> new_vec = node.getState();
 		for(int j = i; j < i + k; j++) {
 			new_vec[j] *= -1;
 		}
 		Node n(new_vec, node.getDepth()+1);
 		res.push_back(n);
 	}
 	return res;
 }
 
 int solve_A_2(vector<int> vec, int k)
 {
 	mypq_type Q;
 	set<Node> open;
 	set<Node> visited;
 	
 	Node root(vec, 0);
 	Q.push(root);
 	open.insert(root);
 
 	while(!Q.empty())
 	{
 		Node t = Q.top();
 		Q.pop();
 		open.erase(t);
 		visited.insert(t);
 		
 		if(t.getDepth() > 2000)
 			return -1;
 
 		if(is_finished(t.getState())){
 			return t.getDepth();
 		}
 		vector<Node> children = open_node(t, k);
 		for (int i = 0; i < children.size(); ++i)
 		{
 			if(visited.find(children[i]) == visited.end() && open.find(children[i]) == open.end()) 
 				Q.push(children[i]);
 		}
 	}
 }
 
 // bool check_impossible(vector<int> vec, int k) {
 	// int num_zeros = 0;
 	// for(auto &it: vec) {
 		// if (it == -1)
 			// num_zeros++;
 	// }
 	// int len = vec.size();
 	// for(int i =0; i < 100000; ++i) {
 		// if ((i * k + num_zeros) % 2 == 0)
 			// return true;
 	// }
 	// return false;
 // }