#include <iostream>
 #include <vector>
 #include <cassert>
 #include <unistd.h>
 
 using namespace std;
 
 int nTests = 0;
 
 bool flip (std::vector<bool> & a, int start, int n){
 	if ((unsigned int)(start + n) > a.size()){
 //		cout << "Impossible flip. Start: " << start << ", n:" << n << ", count: " << a.size() << endl;
 		return false;
 	}
 		
 	for (int i = 0; i < n; i++)
 		a[start+i] = !a[start+i];
 	
 	return true;
 }
 
 int main(){
 	//read input
 	cin >> nTests;
 	std::vector<std::vector<bool>> tests(nTests);
 	std::vector<int> flippers(nTests);
 	
 	for (int i = 0; i<nTests; i++){
 		char c;
 		cin >> c;
 		while(c != '\0'){
 			if (c == '+')
 				tests[i].push_back (true);
 				
 			else if (c == '-')
 				tests[i].push_back(false);
 				
 			else{
 				cin.putback (c);
 				break;
 			}
 
 			cin >> c;
 		}
 		cin >> flippers[i];
 	}
 	
 	//solve
 	
 	for (int i = 0; i<nTests; i++){
 		int flipCount = 0, blankCount = 0;
 		bool happy = false, didFlip = true;
 		
 		while (didFlip){
 			
 			/*cout << "Test " << i << endl;
 			for (bool x: tests[i]){
 				if (x)
 					cout << "+";
 				else
 					cout << "-";
 			}
 			cout << endl;*/
 			
 			happy = true; didFlip = false;
 			
 			for (unsigned int j = 0; j<tests[i].size(); j++){
 				//is pancake happy?
 				if (tests[i][j]){
 					//there are some blank pancakes before ( < K)
 					if (blankCount != 0){
 						//immediatly check remaining pancakes
 						for (int y = 1; y < flippers[i] - blankCount; y++){
 							//there's another blank. Unflippable...
 							if (!tests[i][j+y]){
 								happy = false;
 								goto exit;
 							}
 						}
 						
 						//ok. Let's flip.
 						if (flip (tests[i], j, flippers[i])){
 							didFlip = true;
 							flipCount++;
 							blankCount = 0;
 							break;
 						}
 						else {
 							happy = false;
 							goto exit;
 						}
 						
 					}
 				}
 				else{
 					//row is not happy
 					happy = false;
 					blankCount++;
 				
 					//K element are blank. Flip'em
 					if (blankCount == flippers[i]){
 						if (flip (tests[i], j-flippers[i]+1, flippers[i])){
 							didFlip = true;
 							flipCount++;
 							blankCount = 0;
 							break;
 						}
 						else{
 							happy = false;
 							goto exit;
 						}
 					}
 				}
 			}
 		}
 		
 		exit:
 		cout << "Case #" << i+1 << ": ";
 		if (happy)
 			cout << flipCount << endl;
 		else
 			cout << "IMPOSSIBLE" << endl;
 	}
 	
 	//Print arrays
 	/*for (int i = 0; i<nTests; i++){
 		std::vector<bool> a = tests[i];
 			
 		for (bool c: a)
 			cout << c;
 		
 		cout << " K: " << flippers[i] << endl;
 	}*/
 	
 	return 0;
 }
