#include <iostream>  // includes cin to read from stdin and cout to write to stdout
 #include <string>
 #include <climits>
 using namespace std;  // since cin and cout are both in namespace std, this saves some text
 bool isHappy(string cookies)
 {
    for(char c : cookies)
    {
       if(c == '-')
       {
            return false;
       }   
    }
    return true; 
 }
 string flipCookies(string &cookies, int pos,int n)
 { 
     for(int i = pos; i<cookies.length() && i < pos+n; i++)
     {
        if(cookies[i] == '+')
        {
            cookies[i] = '-';
        }
        else
            cookies[i] = '+';
     }
    return cookies;
 }
 int findMinFlipCount(string cookies, int n)
 {
    int result = 0;
    int length = cookies.length();
    int ways = length - n + 1;
    bool is_happy=isHappy(cookies);
    if(is_happy)
       return 0;
    if(!is_happy && n >= length)
       return INT_MAX;
    bool do_flip = false;
    int i,j;
    for(i = 0; i<ways; i++)
    {
        for(j = 0; j <n; j++)
        {
           if(cookies[i+j] == '-')
            {
              do_flip = true;
              break;  
            } 
        }
        if(do_flip)
        {
           flipCookies(cookies,i,n);
           do_flip = false;
           result = result + 1;
           i = i +j;       
        }
    }
    for(int k = i; k < length; k++)
    {
       if(cookies[k] == '-')
        {
           result = INT_MAX;
        }    
    }  
    return result;
 }
 
 int main() {
   int t, n;
   string cookies;
   cin >> t;  // read t. cin knows that t is an int, so it reads it as such.
   for (int i = 1; i <= t; ++i) {
     cin >> cookies;   // read cookies current state and n
     cin >> n;
     int flip_count = findMinFlipCount(cookies, n);
     if(flip_count != INT_MAX){
        cout << "Case #" << i << ": " << flip_count << endl;
     }else
     {
        cout << "Case #" << i << ": Impossible"<< endl;
     }  
   }
  return 0;
 }
  
