#include <iostream>
 #include <fstream>
 
 #include <vector>
 #include <sstream>
 
 using namespace std;
 
 /*
   search for the configuration that - (k-1)+ -
 */
 int searchConfigMid(const string &s, int start, int k) {
   int l = s.length();
   int i = start;
   int j, c;
   while(i < l) {
     j = i;
     // cout << "   " << i << endl;
     if(s[j] == '-') {
       // cout << "       " << j << endl;
       j++;
       c = 0;
       while(j < l && s[j]=='+') {
         j++;
         c++;
       }
       // cout << "c: " << c << "; j = " << j << endl;
       if( (c==(k-1)) && j<l && (s[j] == '-') )
         return i;
     }
     i++;
   }
 
   return -1;
 }
 
 int areAllHappy(const string &s) {
   int l = s.length();
   int j = 0;
   while(j<l) {
     if(s[j] == '-')
       break;
     j++;
   }
   return j>=l?1:0;
 }
 
 int searchKNegCont(const string &s, int k, int start) {
   int i;
   int len = s.length();
   int j = start;
   int l;
   // cout << "len " << len << endl;
   while(j<len-k+1) {
     i = j;
     // cout << "j: " << j << endl;
     l = 0;
     while(i<len && s[i]=='-') {
       l++;
       // cout << " i: " << i << "; l=" << l << " k=" << k << endl;
       if(l==k) {
         return j;
       }
       i++;
       // cout << " s[" << i << "] " << s[i] << endl;
     }
     j++;
   }
 
   return -1;
 }
 
 int main(int argc, char** args) {
   if(argc < 2) {
     cout << "Not enough parameter." << endl;
     return 1;
   }
   ifstream input(args[1]);
 
   if(input.fail()) {
     cout << "Could not open input file." << endl;
     return 2;
   }
   
   ofstream out(args[2]);
 
   int num_of_case;
   int flip;
   int pancake_count;
   int c, pos1, pos2;
   int k, j;
   bool impossible;
   string line;
   string pks;
 
   input >> num_of_case;
   getline(input, line);
   for(c=0; c < num_of_case; c++) {
     getline(input, line);
     stringstream ss(line);
     ss >> pks;
     ss >> k;
     // cout << "pancakes: " << pks << " k = " << k << endl;
     pancake_count = pks.length();
     flip = 0;
     impossible = false;
     while(!areAllHappy(pks) && !impossible) {
       //search for longest
       pos1 = searchKNegCont(pks, k, 0);
       pos2 = searchConfigMid(pks, 0, k);
       // cout << "k-blank: " << pos1 << endl;
       // cout << "Happy-mid: " << pos2 << endl;
       if(pos1>=0) {
         if(pos2 > pos1 || pos2 < 0) {
           for(j=0; j<k; j++) {
             pks[pos1+j] = '+';
           }
           flip++;
           // cout << pks << endl;
         } else if(pos1 > pos2) {
           for(j=0; j<=k; j++) {
             pks[pos2+j] = '+';
           }
           flip += 2;
         }
       } else {
         //pos1 < 0
         if(pos2 >=0 ) {
           for(j=0; j<=k; j++) {
             pks[pos2+j] = '+';
           }
           flip += 2;
         } else {
           impossible = true;
         }
       }
     }
 
     if(impossible) {
       cout << "Case #" << (c+1) << ": IMPOSSIBLE" << endl;
 	  out << "Case #" << (c+1) << ": IMPOSSIBLE" << endl;
     } else {
       cout << "Case #" << (c+1) << ": " << flip << endl;
 	  out << "Case #" << (c+1) << ": " << flip << endl;
     }
 
   }
 	out.close();
   input.close();
   return 0;
 }
