#include <iostream>  // includes cin to read from stdin and cout to write to stdout
 #include <fstream>  // includes cin to read from stdin and cout to write to stdout
 
 #include <string>
 
 using namespace std;  // since cin and cout are both in namespace std, this saves some text
 
 std::string solve(std::string pattern, int K);
 
 int main() {
     int tc, K;
     std::string pattern;
     
     ifstream file("./a.txt");
     ofstream ofile("./o.txt");
     file >> tc;  // read t. cin knows that t is an int, so it reads it as such.
     
     for (int i = 1; i <= tc; ++i)
     {
         
         file >> pattern >> K;
  
         cout << "Case #" << i << ": " << solve(pattern, K) << " " << endl;
         ofile << "Case #" << i << ": " << solve(pattern, K) << " " << endl;
         
     }
     return 0;
 }
 
 std::string solve(std::string pattern, int K)
 {
     auto max = pattern.size() - K + 1;
     int step=0;
     char prev='+';
     for (auto c : pattern)
     {
         if (prev != c && prev == '+' )
         {
             // cout << prev << c << "|";
             step++;
         }
         prev = c;
     }
     
     return max < step ? "IMPOSSIBLE" : std::to_string(step);
 }
 
 /*lapat pala max pozicio
 K = S   => 1
 K = S-1 => 2
 
 ...
 
 K = 1  => S
 
 3 = S - 5 => 6    S = 8
 
 
 1 2 3 4 5 678
 
 
 1 1 - 0 0 0
 1 0 - 0 1 I
 0 1 - 1 0 I
 0 0 - 1 1 1
 
 000 111
 001 110
 010
 011
 100
 101
 110
 111
 
 11 00 11 00
 
 *000 011
 111 *011
 11 *110 0
 110 *010
 11 *010 1
 111011
  
 
 110
 101
 011
 
 000
 000
 001
 011
 
 000011011
 
 100011
 111111
 
 */
 
 
