#include <cstdio>
 #include <cstring>
 #include <algorithm>
 #include <vector>
 #include <iostream>
 #include <cassert>
 #include <cmath>
 #include <string>
 #include <queue>
 #include <set>
 #include <map>
 #include <cstdlib>
 
 using namespace std;
 
 #define TASKNAME ""
 
 void solve(int test_number);
 
 int main() {
     ios_base::sync_with_stdio(false);
     cin.tie(nullptr);
     cout.setf(ios::fixed);
     cout.precision(9);
     cerr.setf(ios::fixed);
     cerr.precision(3);
 #ifdef LOCAL
     freopen("test.in", "r", stdin);
     freopen("test.out", "w", stdout);
 #else
 #endif
     int n;
     cin >> n;
     for (int i = 0; i < n; i++) {
         solve(i);
     }
 }
 
 const int MAX_N = 1005;
 
 const double eps = 1e-9;
 
 struct point {
     int x, y, z;
 
     point(int x = 0, int y = 0, int z = 0): x(x), y(y), z(z) {}
 };
 
 point operator-(const point& p1, const point& p2) {
     return point(p1.x - p2.x, p1.y - p2.y, p1.z - p2.z);
 }
 
 int n, s;
 point p[MAX_N], vel[MAX_N];
 
 long long sq(long long x) {
     return (long long)x * x;
 }
 
 long long dot(point a, point b) {
     return a.x * b.x + a.y * b.y + a.z * b.z;
 }
 
 long long len(point p) {
     return dot(p, p);
 }
 
 pair<double, double> solution(int u, int v, double dist) {
     double C = len(p[u] - p[v]) - dist;
     double B = 2 * dot(p[u] - p[v], vel[u] - vel[v]);
     double A = len(vel[u] - vel[v]);
     double delta = B * B - 4 * A * C;
     if (delta < 0) {
         return make_pair(-1, -1);
     }
     double t1 = (-B - sqrt(delta)) / (2.0 * A);
     double t2 = (-B + sqrt(delta)) / (2.0 * A);
     return make_pair(t1, t2);
 }
 
 double earliest(int u, int v, double t, double dist) {
     pair<double, double> sol = solution(u, v, dist);
     double t1 = sol.first;
     double t2 = sol.second;
     if (t1 < 0) {
         return -1;
     }
     if (t1 > t - eps) {
         return t1;
     } else if (t2 > t - eps) {
         return t;
     }
     return -1;
 }
 
 bool possible(double dist) {
     double d[MAX_N];
     for (int i = 0; i < n; i++) {
         d[i] = -1.0;
     }
     priority_queue<pair<double, int>> q;
     q.push(make_pair(0, 0));
     while (!q.empty()) {
         double t = -q.top().first;
         int u = q.top().second;
         q.pop();
         if (d[u] >= 0) {
             continue;
         }
         d[u] = t;
         vector<pair<double, double>> sols;
         for (int v = 0; v < n; v++) {
             pair<double, double> sol = solution(u, v, dist);
             if (sol.first >= 0) {
                 sols.push_back(sol);
             }
         }
         sort(sols.begin(), sols.end());
         double max_reach = d[u] + s;
         for (auto sol : sols) {
             if (sol.first < max_reach + eps) {
                 max_reach = max(max_reach, sol.second + s);
             }
         }
         double max_wait = max_reach - d[u];
 
         for (int v = 0; v < n; v++) {
             if (d[v] < 0) {
                 double e = earliest(u, v, d[u], dist);
                 if (e > d[u] - eps && e < d[u] + max_wait + eps) {
                     q.push(make_pair(-e, v));
                 }
             }
         }
     }
     return d[1] >= 0;
 }
 
 void solve(int test_number) {
     cin >> n >> s;
     for (int i = 0; i < n; i++) {
         cin >> p[i].x >> p[i].y >> p[i].z;
         cin >> vel[i].x >> vel[i].y >> vel[i].z;
     }
     double lo = 0.0, hi = 100000000;
     for (int i = 0; i < 200; i++) {
         double mid = (lo + hi) / 2.0;
         if (possible(mid)) {
             hi = mid;
         } else {
             lo = mid;
         }
     }
     cout << "Case #" << test_number + 1 << ": " << sqrt(hi) << endl;
 }
