#include <iostream>
 #include <algorithm>
 #include <vector>
 #include <cstdio>
 using namespace std;
 
 long long average(long long a, long long b) { return (a + b) / 2; }
 
 long long served(int b, vector<int>& v, long long time)
 {
 	long long total = 0;
 	for (int k = 0; k < v.size(); k++) total += time / v[k];
 	return total;
 }
 
 int barberNo(int b, vector<int>& v, long long n, long long time)
 {
 	long long int min = v[0];
 	for (int k = 1; k < v.size(); k++)
 		if (v[k] < min) min = v[k];
 	time -= min;
 	int pre = served(b, v, time);
 	//cout << "pre: " << pre << endl;
 	while (true)
 	{
 		for (int k = 0; k < v.size(); k++)
 		{
 			if (time % v[k] == 0)
 			{
 				if (++pre == n)
 				{
 					return k + 1;
 				}
 			}
 		}
 		time++;
 	}
 }
 
 long long which(int b, long long n, vector<int>& v)
 {
 	long long max = 0;
 	for (int k = 0; k < v.size(); k++) { if (v[k] > max) max = v[k]; }
 	long long maxTime = max * n;
 	long long minTime = 0;
 	long long avgTime = average(minTime, maxTime);
 	long long answer = -1;
 	int inarow = 0;
 	long long prev = -1;
 	while (true)
 	{
 		answer = served(b, v, avgTime);
 		if (answer == prev) inarow++;
 		if (answer == n || inarow > 5) return barberNo(b, v, n, avgTime);
 		if (answer < n) // need more time
 		{
 			minTime = avgTime;
 			avgTime = average(minTime, maxTime);
 		}
 		else
 		{
 			maxTime = avgTime;
 			avgTime = average(minTime, maxTime);
 		}
 		prev = answer;
 		//cout << answer << endl;
 	}
 }
 
 int main()
 {
 	long long t, b, n;
 	cin >> t;
 	for (int k = 1; k <= t; k++)
 	{
 		cin >> b >> n;
 		vector<int> v;
 		while (b--)
 		{
 			int y; cin >> y; v.push_back(y);
 		}
 		printf("Case #%d: %d\n", k, which(b, n, v));
 	}
 }
