#include <cstdio>
 
 int barbers[1005];
 
 long long int processed(long long int mins, int b) {
     long long int result = 0;
     for (int i = 0; i < b; ++i) {
         result += mins / barbers[i];
     }
     return result;
 }
 
 int main() {
     int T;
     scanf("%d", &T);
     for (int t = 1; t <= T; ++t) {
         int b, n;
         scanf("%d %d", &b, &n);
         for (int i = 0; i < b; ++i) {
             scanf("%d", &barbers[i]);
         }
         if (n <= b) {
             printf("Case #%d: %d\n", t, n);
             continue;
         }
         --n; // FOR REASONS
         // sort(barbers, barbers + b);
         
         // binary search for the time that gives n
         long long int l = 1;
         long long int r = 100000000000000;
         long long int m;
         long long int result;
         while (l <= r) {
             m = (l + r) / 2;
             result = processed(m, b);
             // printf("  m at %lld gives %lld\n", m, result);
             if (result < n) {
                 l = m + 1;
             } else {
                 r = m - 1;
             }
         }
         if (result < n) {
             ++m;
         }
         result = processed(m, b);
         long long int prevResult = processed(m-1, b);
         int position;
         if (n == result) {
             position = 0;
         } else {
             position = n - prevResult; // diff from prev
         }
         // printf("position is %d\n", position);
         int curPos = 0;
         int barberNum = -1;
         for (int i = 0; i < b; ++i) {
             barbers[i] = m % barbers[i];
             if (barbers[i] == 0) {
                 if (curPos == position) {
                     barberNum = i + 1;
                     break;
                 }
                 ++curPos;
             }
         }
         // printf("m is %lld(%lld) %lld(%lld)\n", m, result, m - 1, prevResult);
         printf("Case #%d: %d\n", t, barberNum);
     }
 }
