#include <iostream>
 
 using namespace std;
 
 #define ULL unsigned long long
 
 ULL gcd(ULL a, ULL b)
 {
 	while(b)
 		swap(a%=b, b);
 	
 	return a;
 }
 
 ULL lcm(ULL a, ULL b)
 {
 	return (a/gcd(a, b))*b;
 }
 
 int main()
 {
 	ios_base::sync_with_stdio(0);
 	
 	int t;
 	cin >> t;
 	
 	for(int k=1; k<=t; k++)
 	{
 		ULL b, n;
 		cin >> b >> n;
 		ULL m[b];
 		for(int i=0; i<b; i++)
 			cin >> m[i];
 			
 		ULL timeInterval = 1;
 		for(int i=0; i<b; i++)
 			timeInterval = lcm(timeInterval, m[i]);
 		
 		ULL numOfClients = 0;
 		for(int i=0; i<b; i++)
 			numOfClients += timeInterval/m[i];
 			
 		n %= numOfClients;
 		
 		//simulate
 		int whenFree[b];
 		for(int i=0; i<b; i++) whenFree[i] = 0;
 		
 		//simulate customer by customer
 		int barber = -1;
 		for(int i=0; i<n; i++)
 		{
 			barber = -1;
 			for(int j=0; j<b; j++)
 				if(whenFree[j] = 0)
 				{
 					barber = j;
 					whenFree[j] = m[j];
 					break;
 				}
 			
 			if(barber == -1)
 			{
 				int minV = 2000000, minB = -1;
 				for(int j=0; j<b; j++)
 					if(whenFree[j] < minV)
 					{
 						minV = whenFree[j];
 						minB = j;
 					}
 				
 				for(int j=0; j<b; j++)
 					whenFree[j] -= minV;
 				
 				whenFree[minB] = m[minB];
 				barber = minB;
 			}
 		}
 		
 		if(barber == -1)
 			barber = b-1;
 		
 		cout << "Case #" << k << ": " << barber+1 << "\n";
 	}
 	
 	return 0;
 }
