/**
 * @file haircut.cpp
 * @author Samuel Yee
 *
 * Code for problem B of Google Code Jam Problem 1A, Haircut.
 *
 */
 
 #include <string>
 #include <vector>
 #include <iostream>
 #include <fstream>
 #include <sstream>
 #include <algorithm>
 
 using namespace std;
 
 #define CLEAR(ss) \
 	(ss).str(string()); \
 	(ss).clear();
 
 #define LINES_PER_CASE 2
 
 string process_case(vector<string> lines);
 
 // main only handles input/output
 int main(int argc, char* argv[]) {
 	if (argc != 2) {
 		cout << "Usage: " << argv[0] << " inputfile" << endl;
 		return -1;
 	}
 
 	string inputfilename(argv[1]);
 
 	ifstream infile;
 	infile.open(inputfilename);
 	if (!infile) {
 		cout << "Could not open " << argv[1] << endl;
 		return -1;
 	}
 
 	size_t pos = inputfilename.find(".");
 	string outputfilename = inputfilename.substr(0, pos);
 	outputfilename.append(".out");
 
 	ofstream outfile;
 	outfile.open(outputfilename);
 
 	// get number of test cases
 	int num_cases = 0;
 	infile >> num_cases;
 
 	string line;
 
 	// discard the rest of the line
 	getline(infile, line);
 
 	for (int i = 0; i < num_cases; ++i) {
 		cout << "Running case " << i+1 << endl;
 		vector<string> input;
 
 		for (int j = 0; j < LINES_PER_CASE; ++j) {
 			getline(infile, line);
 			input.push_back(line);
 		}
 
 		string result = process_case(input);
 		outfile << "Case #" << i+1 << ": " << result << endl;
 	}
 
 	infile.close();
 	outfile.close();
 }
 
 // end template
 
 string process_case(vector<string> lines) {
 	stringstream ss;
 	ss.str(lines[0]);
 
 	int b;
 	unsigned long n;
 	ss >> b >> n;
 
 	CLEAR(ss);
 	ss.str(lines[1]);
 	int m[b];
 	int max_time = 0;
 	for (int i = 0; i < b; ++i)
 	{
 		ss >> m[i];
 		max_time = m[i] > max_time ? m[i] : max_time;
 	}
 
 	// binary search for the time before you are served.
 	unsigned long long waiting_time = max_time * (n - 1);
 	unsigned long long low_waiting_time = 0;
 	unsigned long long high_waiting_time = waiting_time;
 	unsigned long long customers_served = 0;
 
 	while (true) {
 		customers_served = 0;
 		for (int i = 0; i < b; ++i)
 		{
 			customers_served += waiting_time / m[i];
 		}
 		// cout << customers_served << endl;
 		// we found the right time
 		if (customers_served == n - 1)
 			break;
 		// our time is too long
 		else if (customers_served > n - 1) {
 			high_waiting_time = waiting_time;
 		}
 		// our time is too short
 		else {
 			low_waiting_time = waiting_time;
 		}
 
 		// degenerate case
 		if (high_waiting_time <= low_waiting_time+1)
 			break;
 
 		waiting_time = low_waiting_time + ((high_waiting_time - low_waiting_time) >> 1);
 	}
 
 	cout << "Customers served: " << customers_served << endl;
 
 	int test = (customers_served < n-1) ? customers_served : n-1;
 	// get the actual waiting time
 	while (customers_served >= test) {
 		--waiting_time;
 		customers_served = 0;
 		for (int i = 0; i < b; ++i)
 		{
 			customers_served += waiting_time / m[i];
 		}
 
 	}
 	customers_served = 0;
 	for (int i = 0; i < b; ++i)
 	{
 		customers_served += waiting_time / m[i];
 	}
 	cout << "Actual customers_served: " << customers_served << endl;
 	cout << "Waiting time: " << ++waiting_time << endl;
 
 	// now find the lowest barber who is free
 	int time_left[b];
 	int time_left_copy[b];
 
 	for (int i = 0; i < b; ++i)
 	{
 		time_left[i] = waiting_time % m[i];
 		time_left_copy[i] = time_left[i];
 	}
 	sort(time_left, time_left + b);
 	
 	int val = time_left[n - customers_served - 1];
 	int customers_left = n - customers_served - 1;
 
 	cout << customers_left << endl;
 
 	int count = 0;
 	for (int i = 0; i < b; ++i)
 	{
 		if (time_left[i] <= val) {
 			if (customers_left == 0) {
 				count = i;
 				break;
 			}
 			else
 				--customers_left;
 		}
 	}
 
 
 
 	CLEAR(ss);
 	ss << count + 1;
 	return ss.str();
 
 }