#include<cstdio>
 #include<cmath>
 #include<vector>
 #include<set>
 #include<algorithm>
 
 using namespace std;
 
 struct pt{
 	long long x, y;
 	pt(long long _x, long long _y): x(_x), y(_y) {}
 	bool operator<(const pt &rhs) const{
 		if(this->x==rhs.x) return this->y<rhs.y;
 		return this->x<rhs.x;
 	}
 };
 
 bool is_concave(pt &p, pt &q, pt &r)
 {
 	long long dx1, dx2, dy1, dy2;
 	dx1=q.x-p.x; dy1=q.y-p.y;
 	dx2=r.x-q.x; dy2=r.y-q.y;
 //	printf("p=%lld,%lld q=%lld,%lld r=%lld,%lld dx1*dy2=%lld dy1*dx2=%lld\n",
 //		p.x,p.y,q.x,q.y,r.x,r.y,dx1*dy2,dx2*dy1);
 	return dx1*dy2<dx2*dy1;
 }
 
 bool is_convex(pt &p, pt &q, pt &r)
 {
 	long long dx1, dx2, dy1, dy2;
 	dx1=q.x-p.x; dy1=q.y-p.y;
 	dx2=r.x-q.x; dy2=r.y-q.y;
 //	printf("p=%lld,%lld q=%lld,%lld r=%lld,%lld dx1*dy2=%lld dy1*dx2=%lld\n",
 //		p.x,p.y,q.x,q.y,r.x,r.y,dx1*dy2,dx2*dy1);
 	return dx1*dy2>dx2*dy1;
 }
 
 void solve()
 {
 	int n;
 	scanf("%d",&n);
 	vector<pt> p, original;
 	for(int i = 0; i < n; i++)
 	{
 		long long x, y;
 		scanf("%lld%lld",&x,&y);
 		p.push_back(pt(x,y));
 		original.push_back(pt(x,y));
 	}
 	if(n==1)
 	{
 		printf("0\n");
 		return;
 	}
 	sort(p.begin(),p.end());
 	vector<pt> chain;
 	chain.push_back(p[0]);
 	for(int i = 1; i < n; i++)
 	{
 		while(chain.size()>1)
 		{
 			int m = chain.size()-1;
 			if(is_concave(chain[m-1],chain[m],p[i]))
 				chain.pop_back();
 			else break;
 		}
 		chain.push_back(p[i]);
 	}
 	int m=chain.size();
 	for(int i = n-2; i>=0 ; i--)
 	{
 		//if(p[i].x==p.back().x) continue;
 		while(chain.size()>m)
 		{
 			int x = chain.size()-1;
 			if(is_concave(chain[x-1],chain[x],p[i]))
 				chain.pop_back();
 			else break;
 		}
 		chain.push_back(p[i]);
 	}
 	chain.pop_back();
 	set<pt> bound;
 	for(int i = 0; i < chain.size(); i++)
 		bound.insert(chain[i]);
 	m=chain.size();
 	for(int i = 0; i < m; i++)
 	{
 //		printf("x%lld y%lld\n",chain[i].x, chain[i].y);
 		chain.push_back(chain[i]);
 	}
 	for(int i = 0; i < n; i++)
 	{
 		int cnt=0;
 		if(bound.count(original[i])==0)
 		{
 			int L, R;
 //			puts("!!");
 			for(L=0, R=1, cnt=0x7FFFFFFF; L<m; L++)
 			{
 				for(R=max(R,L+1); 
 					is_concave(chain[L],original[i],chain[R]) && R-L<=m; 
 					R++);
 				//cnt=max(cnt,min(R-L-1,m-L+R-1));
 				cnt=min(cnt,R-L-1);
 			}
 		}
 		printf("%d\n",cnt);
 	}
 }
 
 int main()
 {
 	int ncases;
 	scanf("%d",&ncases);
 	for(int i = 1; i <= ncases; i++)
 	{
 		printf("Case #%i:\n",i);
 		solve();
 	}
 	return 0;
 }
