#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <set>
#include <map>
#include <queue>
#include <math.h>
#define loop(i, n) for(long i = 0; i < (n); i++)
#define loopi(n) loop(i, n)
#define pb push_back
#define mp make_pair
#define full(arr) arr.begin(), arr.end()
#define ll long long
using namespace std;
vector<ll> p10;
set<pair<char, int> > made;
string ans;
class Node {
public:
    set<int> potential_chars;
    int value;
    Node () {
        value = -1;
        for (int i = 0; i < 10; ++i) {
            potential_chars.insert(i);
        }
    }
    bool check_value() {
        if (potential_chars.size() == 1) {
            value = *(potential_chars.begin());
            // cout << "Found " << value << endl;
            return true;
        }
        return false;
    }
    bool remove_val(int v) {
        if (value != -1) return false;
        potential_chars.erase(v);
        return check_value();
    }
    bool remove_greater(int v) {
        if (value != -1) return false;
        auto it = potential_chars.upper_bound(v);
        while(it != potential_chars.end()){
            potential_chars.erase(it);
            it = potential_chars.upper_bound(v);
        }
        return check_value();
    }
};
map<char, Node> keys;

ll get_digits (ll &val) {
    int digits = log10(val);
    return digits + 1;
}

void make_value (map<char, Node> &keys, char c, int v) {
    if (made.find(mp(c, v)) != made.end())
        return;
    made.insert(mp(c, v));
    ans[v] = c;
    for (auto it = keys.begin(); it != keys.end(); ++it) {
        if (it->first == c) {
            if (it->second.value != -1 && it->second.value != v)
                throw logic_error("There's duplication");
            it->second.value = v;
        } else {
            if (it->second.value == v)
                throw logic_error("Multiple Letters want to be the same digit");
            if (it->second.remove_val(v))
                make_value(keys, it->first, it->second.value);
        }
    }
}
bool comp (const pair<ll, string> &a, const pair<ll, string> &b) {
    if (keys[a.second[0]].value != -1)
        return false;
    if (keys[b.second[0]].value != -1)
        return true;
    int da = a.second.size()-1;
    int db = b.second.size()-1;
    int fa = a.first / p10[da];
    int fb = b.first / p10[db];
    return fa < fb;
}
int main () {
    p10.push_back(1);
    for(int i = 1; i <= 16; ++i)
        p10.push_back(p10.back()*10);
    long t;
    cin >> t;
    loop(t_no, t) {
        keys.clear();
        made.clear();
        ans = string (10, '-');
        ll u, m;
        string query;
        cin >> u;
        ll max_val = p10[u] - 1;
        vector<pair<ll, string>> cbuf;
        for (long tk = 0; tk < 10000; ++tk) {    
            cin >> m >> query;
            if (m == -1) 
                m = max_val;
            for (int i = 0; i < query.size(); ++i) {
                if (keys.find(query[i]) == keys.end()) {
                    keys[query[i]] = Node();
                }
            }
            int digits = get_digits(m);
            if (digits == query.size())
                cbuf.push_back(mp(m, query));
            else if (digits < query.size())
                throw std::logic_error("IMPOSSIBLE case");
            if (m == 1) {
                make_value(keys, query[0], 1);
            }
            if (keys[query[0]].remove_val(0))
                make_value(keys, query[0], keys[query[0]].value);
        }
        if (keys.size() != 10)
            throw std::out_of_range("10 digits not present");
        while (!cbuf.empty() && (ans.find('-') != string::npos)) {
            sort(cbuf.begin(), cbuf.end(), comp);
            vector<pair<ll, string>> buf;
            for (int i = 0; (i < cbuf.size()) && (ans.find('-') != string::npos); ++i) {
                m = cbuf[i].first;
                query = cbuf[i].second;
                int d = query.size();
                int f = m / p10[d-1];
                Node *first_node = &keys[query[0]];
                if (first_node -> remove_greater(f))
                    make_value(keys, query[0], first_node -> value);
                if (first_node -> value != -1) {
                    if (f == first_node -> value) {
                        if(query.size() != 1)
                            buf.push_back(mp(m%p10[d-1], query.substr(1)));
                    } else if (f < first_node -> value) 
                        throw logic_error("Found answer is larger than guess");
                } else {
                    buf.push_back(mp(m, query));
                }
            }
            cbuf = buf;
        }
        if (ans.find('-') != string::npos)
            throw logic_error("Inconclusive answer found");
        cout << "Case #" << t_no + 1 << ": ";
        cout << ans;
        cout << endl;
    }
    return 0;
}