#include<iostream>
#include<cstring>
#include<algorithm>
using namespace std;

int queries[1010];
char results[1010][20];
char letters[10];

void clearLetters() {
    for (int i = 0; i < 10; i++) {
        letters[i] = '.';
    }
}
void addLetter(char l) {
    for (int i = 0; i < 10; i++) {
        if (letters[i] == l) {
            return;
        }
        if (letters[i] == '.') {
            letters[i] = l;
            return;
        }
    }
    printf("%d", 1/0);
}
bool allLettersFound() {
    for (int i = 0; i < 10; i++) {
        if (letters[i] == '.') {
            return false;
        }
    }
    return true;
}

int letterToDigit(char l) {
    for (int i = 0; i < 10; i++) {
        if (letters[i] == l) {
            return i;
        }
    }
    return 1/0;
}
int decode(char* encoded) {
    int decoded = 0;
    for (int i = 0; i < strlen(encoded); i++) {
        decoded = 10*decoded + letterToDigit(encoded[i]);
    }
    return decoded;
}
bool checkQueries() {
    for (int i = 0; i < 1000; i++) {
        if (queries[i] == -1) {
            continue;
        }

        int decoded = decode(results[i]);

        // if (letters[0] == results[i][0]) {
        //     return false;
        // }

        if (decoded < 1 || decoded > queries[i]) {
            return false;
        }
    }
    return true;
}

int main() {
    int tests;
    scanf("%d", &tests);
    for (int test = 1; test <= tests; test++) {
        clearLetters();

        int u;
        scanf("%d", &u);
        for (int i = 0; i < 1000; i++) {
            scanf("%d %s", &queries[i], results[i]);
            if (queries[i] == -1) {
                queries[i] = 10000;
            }
            for (int j = 0; j < strlen(results[i]); j++) {
                addLetter(results[i][j]);
            }
        }


        sort(letters, letters+10);
        do {
            if (checkQueries()) {
                printf("CASE #%d: %s\n", test, letters);
                break;
            }
        } while (next_permutation(letters, letters+10));
    }

    return 0;
}
