#include <iostream>
#include <vector>
#include <string>
#include <map>

using namespace std;

int num_digits(int n)
{
    int digits = 0;
    while (n)
    {
        n /= 10;
        digits++;
    }
    return digits;
}

int intPow(int x, int p)
{
    if (p == 0) return 1;
    if (p == 1) return x;

    int tmp = intPow(x, p / 2);
    if (p % 2 == 0) return tmp * tmp;
    else return x * tmp * tmp;
}

void insert(map<char, pair<int, int>>& possibilities, const int & n, const string& a, const int & U)
{
    if (n < 0)
    {

    }
    else
    {
        int d = num_digits(n);

        if (d == a.size())
        {
            if (d == 1)
            {
                possibilities[a[0]].first = 1;
                if (possibilities[a[0]].second == 0 || possibilities[a[0]].second > n)
                    possibilities[a[0]] = pair<int, int>(1, n);
            }
            else if ((int)(n / intPow(10, d - 1)) == 1)
            {
                possibilities[a[0]] = pair<int, int>(1, 1);
                if (possibilities[a[1]].second == 0 || possibilities[a[1]].second > (n / intPow(10, d - 2)) % 10)
                    possibilities[a[1]].second = (n / intPow(10, d - 2)) % 10;
            }
            else
                if (possibilities[a[0]].second == 0 || possibilities[a[0]].second > n / intPow(10, d - 1))
                    possibilities[a[0]].second = n / intPow(10, d - 1);
        }
    }
}

string elaborate_map(map<char, pair<int, int>> possibilities)
{
    string res = "";
    for (auto& it : possibilities)
        if (it.second.first == 0)
        {
            res += it.first;
            possibilities.erase(it.first);
            break;
        }

    map<int, char> sec;

    for (auto& it : possibilities)
        sec[it.second.second] = it.first;

    for (auto& it : sec)
        res += it.second;

    return res;
}

int main()
{
    int T, U;

    cin >> T >> U;

    vector<string> res(T);

    for (int i = 0; i < T; i++)
    {
        map<char, pair<int, int>> possibilities;

        for (int i = 0; i < 10000; ++i)
        {
            int n;
            string a;
            cin >> n >> a;
            insert(possibilities, n, a, U);
        }

        res[i] = elaborate_map(possibilities);
    }

    for (int i = 0; i < T; i++)
    {
        if (res[i].size() < 10)
            cout << "Case #" << i + 1 << ": IMPOSSIBLE" << endl;
        else
            cout << "Case #" << i + 1 << ": " << res[i] << endl;
    }

    return 0;
}