#include <algorithm>
#include <cstdio>
#include <cstring>
#include <iostream>
#include <string>
#include <set>
#include <vector>
#include <random>

const int Q_NUM = 10000;

std::random_device rd;
std::mt19937 gen(rd());

int u;
long long p10[32];

struct Query {
    long long q;
    std::string q_str;
    std::string r;

    void read() {
        std::cin >> q >> r;
    }

    void set_query() {
        q_str = "";
        long long m;
        if (q == -1) {
            int le_power = r.size() - 1;
            if (r.size() < u) le_power++;
            std::uniform_int_distribution<> dis(p10[le_power], p10[u] - 1);
            m = dis(gen);
        } else {
            m = q;
        }
        while (m) {
            q_str.push_back(m % 10 + '0');
            m /= 10;
        }
        std::reverse(q_str.begin(), q_str.end());
    }
};

const int NEQ = 0;
const int GEQ = 1;

Query qs[10010];
std::set<char> dictionary;
std::string p;
std::set< std::pair<int, char> > vec[16];
int let2dig[32];

void read() {
    std::cin >> u;
    for (int i = 0; i < Q_NUM; i++) {
        qs[i].read();
    }
}

void build_dict() {
    dictionary.clear();
    for (int i = 0; i < Q_NUM && dictionary.size() < 10; i++) {
        for (int j = 0; j < qs[i].r.size(); j++) {
            dictionary.insert(qs[i].r[j]);
        }
    }
    
    p = "";
    for (std::set<char> :: iterator it = dictionary.begin(); it != dictionary.end(); it++) {
        p.push_back(*it);
    }
}

void build_constraints() {
    for (int i = 0; i < 10; i++) {
        vec[i].clear();
    }

    for (int i = 0; i < Q_NUM; i++) {
        // First digit cannot be 0.
        vec[0].insert(std::make_pair(NEQ, qs[i].r[0]));
        // If equal length, first digit must be >= letter.
        if (qs[i].q != -1 && qs[i].q_str.size() == qs[i].r.size()) {
            vec[ qs[i].q_str[0] - '0' ].insert(std::make_pair(GEQ, qs[i].r[0]));
        }
    }
}

void map_letter_to_digit() {
    memset(let2dig, -1, sizeof(let2dig));
    for (int i = 0; i < p.size(); i++) {
        let2dig[ p[i] - 'A' ] = i;
    }
}

int get_digit(char l) {
    return let2dig[l - 'A'];
}

bool check_constraints() {
    for (int i = 0; i < 10; i++) {
        for (std::set< std::pair<int, char> > :: iterator it = vec[i].begin(); it != vec[i].end(); it++) {
            if (it->first == NEQ && i == get_digit(it->second)) return false;
            if (it->first == GEQ && i < get_digit(it->second)) return false;
        }
    }
    return true;
}

bool check() {
    for (int i = 0; i < Q_NUM; i++) {
        if (qs[i].q != -1 && qs[i].q_str.size() == qs[i].r.size()) {
            std::string decoded;
            for (int j = 0; j < qs[i].r.size(); j++) {
                decoded.push_back(get_digit(qs[i].r[j]) + '0');
            }
            if (decoded > qs[i].q_str) return false;
        }
    }
    return true;
}

bool solve_wrapper() {
    for (int i = 0; i < Q_NUM; i++) {
        qs[i].set_query();
    }

    build_dict();
    build_constraints();

    do {
        map_letter_to_digit();
        if (!check_constraints()) {
            continue;
        }
        if (check()) {
            std::cout << p << '\n';
            return true;
        }
    } while (std::next_permutation(p.begin(), p.end()));
    return false;
}

void solve() {
    while (true) {
        if (solve_wrapper()) {
            break;
        }
    }
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr);

    p10[0] = 1LL;
    for (int i = 1; i <= 17; i++) {
        p10[i] = p10[i - 1] * 10L;
    }

    int T;
    std::cin >> T;
    for (int t = 1; t <= T; t++) {
        std::cout << "Case #" << t << ": ";
        read();
        solve();
    }

    return 0;
}
