#include <cstddef>
#include <cstdint>
#include <iostream>
#include <cmath>
#include <vector>
#include <string>
#include <map>
#include <algorithm>
#include <iterator>

std::pair<std::uint64_t, char> flip_pair(const std::pair<char, std::uint64_t> &p)
{
    return std::pair<std::uint64_t, char>(p.second, p.first);
}

std::string find_digit_string(std::vector<std::vector<std::string>> const & querries)
{
  std::map<char, std::uint64_t> frequencies;

  // Find 1-9
  for (auto const & equal_length_querry : querries)
    {
      for (auto const & querry : equal_length_querry)
        {
          ++frequencies[querry[0]];
        }
    }

  std::multimap<std::uint64_t, char> sorted_on_value;
  std::transform(frequencies.begin(), frequencies.end(),
                 std::inserter(sorted_on_value, sorted_on_value.begin()),
                 flip_pair);

  std::string digit_string = "";

  for (auto const & frequency : sorted_on_value)
    {
      digit_string += frequency.second;
    }

  std::reverse(digit_string.begin(), digit_string.end());

  // Find 0
  for (auto const & equal_length_querry : querries)
    {
      for (auto const & querry : equal_length_querry)
        {
          for (auto const character : querry)
            {
              std::string::size_type n;
              n = digit_string.find(character);

              if (n == std::string::npos)
                {
                  digit_string = character + digit_string;
                  break;
                }
            }
        }
    }

  return digit_string;
}
int main()
{
  {
    //timer Timer;

    std::size_t test_cases;
    std::cin >> test_cases;

    for (std::size_t t = 0; t < test_cases; ++t)
      {
        std::size_t upper_bound_digits;
        std::cin >> upper_bound_digits;

        std::vector<std::vector<std::string>> querries(upper_bound_digits);

        for (std::size_t i = 0; i < 10000; ++i)
          {
            std::int64_t querry_number;
            std::cin >> querry_number;

            std::string response;
            std::getline(std::cin, response);

            response = response.substr(1, response.size() - 1);

            if (std::floor(std::log10(querry_number)) + 1 == response.size())
              {
                querries[response.size() - 1].emplace_back(response);
              }
          }

        std::cout << "Case #" << t + 1 << ": ";
        std::cout << find_digit_string(querries) << "\n";
      }
  }
}
