#include <algorithm>
#include <iostream>
#include <map>
#include <queue>
#include <set>
#include <string>
#include <vector>

using namespace std;

#define INT_MAX 2147483647

int main()
{
    int T;
    cin >> T;
    for (int t = 1; t <= T; t++) {
        int U;
        cin >> U;
        vector<pair<string, string>> queries;
        set<char> chars;
        for (int i = 0; i < 10000; i++) {
            int query;
            string response, queryStr;
            cin >> query >> response;
            chars.insert(response.begin(), response.end());
            queryStr = to_string(query);
            if (queryStr.size() == response.size()) {
                queries.emplace_back(queryStr, response);
            }
        }
        set<char> fullSet;
        for (char i = '0'; i <= '9'; i++) {
            fullSet.insert(i);
        }
        map<char, set<char>> mapping;
        for (char c : chars) {
            mapping[c] = fullSet;
        }
        for (auto& query : queries) {
            auto& resp = query.second;
            auto firstRespChar = resp.front();
            mapping[firstRespChar].erase('0');
        }
        map<char, char> uniques;
        for (int j = 0; j < 3; j++) {
            for (auto& query : queries) {
                auto& req = query.first;
                auto& resp = query.second;
                if (req.empty()) {
                    continue;
                }
                auto firstReqChar = req.front(), firstRespChar = resp.front();
                while (uniques.count(firstRespChar) && firstReqChar == uniques[firstRespChar]) {
                    req.erase(req.begin());
                    resp.erase(resp.begin());
                    if (req.empty()) {
                        break;
                    }
                    firstReqChar = req.front(), firstRespChar = resp.front();
                }
                if (req.empty()) {
                    continue;
                }
                for (char i = firstReqChar + 1; i <= '9'; i++) {
                    mapping[firstRespChar].erase(i);
                }
                if (mapping[firstRespChar].size() == 1 && !uniques.count(firstRespChar)) {
                    queue<char> uniqueTraversal;
                    uniqueTraversal.push(firstRespChar);
                    while (!uniqueTraversal.empty()) {
                        auto curChar = uniqueTraversal.front();
                        uniqueTraversal.pop();
                        if (uniques.find(curChar) != uniques.end()) {
                            continue;
                        }
                        uniques[curChar] = *mapping[curChar].begin();
                        for (auto& mapEntry : mapping) {
                            if (mapEntry.first == curChar) {
                                continue;
                            }
                            mapEntry.second.erase(uniques[curChar]);
                            if (mapEntry.second.size() == 1 && !uniques.count(mapEntry.first)) {
                                uniqueTraversal.push(mapEntry.first);
                            }
                        }
                    }
                }
            }
        }
        for (auto& mapEntry : mapping) {
            if (mapEntry.second.size() == 0) {
                abort();
            }
        }
        string code(10, ' ');
        for (auto& mapEntry : uniques) {
            code[mapEntry.second - '0'] = mapEntry.first;
        }
        cout << "Case #" << t << ": " << code << endl;
    }
}
