#include <iostream>
#include <set>
#include <vector>
#include <algorithm>
#include <map>
#include <cassert>
#include <chrono>
#include <random>

std::mt19937 rng(int(std::chrono::steady_clock::now().time_since_epoch().count()));

void solve_test_case()
{
    int U;
    std::cin >> U;

    std::set<char> letters;
    std::set<char> invalid_zero;

    std::vector<std::pair<long long int, std::string>> v;

    for (int i = 0; i < 1e4; i += 1)
    {
        long long int kappa;
        std::string keepo;
        std::cin >> kappa >> keepo;
        invalid_zero.insert(keepo[0]);
        for (const char c : keepo)
        {
            letters.insert(c);
        }

        if (kappa == -1)
        {
            long long int pot = 1;
            for (int i = 0; i < int(keepo.size()); i += 1)
            {
                pot *= 10;
            }
            kappa = 1LL * (std::rand() % int(1e6)) * (std::rand() % int(1e6)) * (std::rand() % int(1e6));
            kappa = std::max(kappa, pot - 1);
        }

        v.push_back({kappa, keepo});
    }

    for (const char valid_zero : letters)
    {

        if (invalid_zero.count(valid_zero))
        {
            continue;
        }

        std::vector<char> chars;

        for (const char c : letters)
        {
            if (c != valid_zero)
            {
                chars.push_back(c);
            }
        }

        std::sort(v.begin(), v.end());

        do
        {
            std::map<char, int> convert;
            int current = 0;
            std::map<int, char> kappaloiro;
            kappaloiro[current] = valid_zero;
            convert[valid_zero] = current++;
            for (const char c : chars)
            {
                kappaloiro[current] = c;
                convert[c] = current++;
            }

            bool valid = true;

            for (const auto &i : v)
            {
                long long int eoq = 1;
                long long int current = 0;
                for (const char c : i.second)
                {
                    eoq *= 10;
                    current *= 10;
                    current += convert[c];
                }
                if (current > i.first)
                {
                    valid = false;
                    break;
                }
            }

            if (valid)
            {
                for (const auto i : kappaloiro)
                {
                    std::cout << i.second;
                }
                std::cout << std::endl;
                return;
            }

        } while (std::next_permutation(chars.begin(), chars.end()));
    }

    assert(false);
}

int main()
{
    std::srand(std::time(NULL));
    std::ios_base::sync_with_stdio(0);
    std::cin.tie(0);
    std::cout.tie(0);

    int T;
    std::cin >> T;

    for (int test = 1; test <= T; test += 1)
    {
        std::cout << "Case #" << test << ": ";
        solve_test_case();
    }

    return 0;
}
