#include <bits/stdc++.h>

using namespace std;
typedef long long ll;

long double confidence[15][30];
long double max_u;

string tostring(ll x) {
    string ans;
    while(x) {
        ans.push_back('0' + x % 10);
        x /= 10;
    }
    reverse(ans.begin(), ans.end());
    return ans;
}

void uniform_process(string s) {
    for(int j = 1; j < 10; j++) {
        long double part = 1.0/9.0;
        confidence[j][s[0] - 'A'] += part;
    }
    for (int i = 1; i < s.size(); i++) {
        int cb = s[i] - 'A';
        for(int j = 0; j < 10; j++) {
            long double part = 1.0/10.0;
            confidence[j][cb] += part;
        }
    }
}

void actual_process(ll x, string s) {
    string xs = tostring(x);
    long double total = x;
    for (int i = 0; i < s.size(); i++) {
        int cb = s[i] - 'A';
        int xb = xs[i] - '0';
        //printf("i == %d, (%c, %c): \n", i, s[i], xs[i]);
        
        ll pot = 1;
        long double pot_d = 1;
        for (int j = 0; j < s.size() - i - 1; j++) {
            pot *= 10;
            pot_d *= 10.0;
        }
        
        //printf("pot: %lld pot_d: %.6Lf\n", pot, pot_d);
        
        ll rem = x % pot;
        long double rem_d = (long double) rem;
        
        // digit
        //printf("rem: %lld\n", rem);
        confidence[xb][cb] += rem_d / total;
        
        // less than digit
        int first_val = (i == 0 ? 1 : 0);
        for (int j = first_val; j < xb; j++) {
            long double am = xb - 1;
            confidence[j][cb] += pot_d / total;
        }
        
        // the rest
        ll rem2 = x % (pot * 10);
        long double rem2_d = (long double) rem2;
        //printf("rem2: %lld\n", rem2);
        
        for (int j = 0; j < 10; j++) {
            confidence[j][cb] += (total - rem2_d) / (10.0*total);
        }
    }
}

int main() {
    int t; cin >> t;
    for(int tt = 1; tt <= t; tt++) {
        for(int i = 0; i < 15; i++) {
            for(int j = 0; j < 30; j++) {
                confidence[i][j] = 1e-15;
            }
        }
        ll u;
        cin >> u;
        for(int q = 0; q < 1e4; q++) {
            ll x; string s;
            cin >> x >> s;
            string xs = tostring(x);
            
            if (xs.size() > s.size())
                uniform_process(s);
            else
                actual_process(x, s);
        }
        
        string ans = "0000000000";
        set<int> used;
        for (int i = 1; i <= 10; i++) {
            int pos = i % 10;
            long double best_conf = 1e-15;
            int best = 0;
            for (char c = 'A'; c <= 'Z'; c++) {
                int cb = c - 'A';
                if(!used.count(cb)) {
                    if (confidence[pos][cb] > best_conf) {
                        best_conf = confidence[pos][cb];
                        best = cb;
                    }
                }
            }
            used.insert(best);
            ans[pos] = 'A' + best;
        }
        printf("Case #%d: %s\n", tt, ans.c_str());
    }
    return 0;
}