#include <cstdio>
#include <iostream>
#include <algorithm>
#include <vector>
#include <string>
#include <set>
#include <map>
using namespace std;
typedef long long LL;
typedef pair<LL, string> PIS;
map<char, LL> rightRange, leftRange;

bool isPossibleNumber(map<char, LL>& char2int, LL num, string& s){
    vector<LL> digit;
    while(num || digit.empty()){
        digit.push_back(num % 10);
        num /= 10;
    }
    reverse(digit.begin(), digit.end());
    for(int i = 0; i < digit.size(); i++){
        if( !i && char2int[s[i]] == 0)
            return false;
        if(char2int[s[i]] > digit[i])
            return false;
        if(char2int[s[i]] < digit[i])
            break;
    }
    
    return true;
}

bool isPossibleDigits(vector<char>&digits, vector<PIS>& numPair, vector<int>& lenNum){
    map<char, LL> char2int;
    for(int i =0; i< digits.size(); i++){
        char2int[digits[i]] = i;
        if(i > rightRange[digits[i]] || i < leftRange[digits[i]])
            return false;
    }

    for(int i=0 ; i < numPair.size(); i++){
        LL num = numPair[i].first;
        string s = numPair[i].second;
        if( char2int[s[0]] == 0)
            return false;
        
        if( lenNum[i] > s.size())
            continue;
        if( !isPossibleNumber(char2int, num, s))
            return false;
    }
    return true;
}



void solve(){
    int tc, tcn =0 ;
    cin >> tc;
    while(tc--){
        int u;
        vector<PIS> numPair;
        set<char> candidates;
        vector<char> digits, permute_digits;
        vector<int> lenNum;
        string digitsStr;
        cin >> u;
        for(int i =0 ; i< 10000; i++){
            LL num;
            string s;
            cin >> num >> s;
            numPair.push_back(PIS(num, s));
            for(int i = 0; i < s.size(); i++){
                candidates.insert(s[i]);
            }
            
            numPair.push_back(PIS(num, s));
        }

        sort(numPair.begin(), numPair.end());
        numPair.erase(unique(numPair.begin(), numPair.end()), numPair.end());
        

        for(set<char>::iterator it = candidates.begin(); it != candidates.end(); it++){
            digits.push_back(*it);
            rightRange[*it] = 9;
            leftRange[*it] = 10;
        }

        

        for(int i = 0; i < numPair.size(); i++){
            int len_num = 0;
            LL num_ = numPair[i].first;
            while( num_){
                len_num++;
                num_ /= 10;
            }
            len_num = max(len_num, 1);
            lenNum.push_back(len_num);
        }
        for(int i=0 ;i< numPair.size(); i++){
            LL num = numPair[i].first;
            string s = numPair[i].second;
            if( lenNum[i] > s.size())
                continue;
            rightRange[s[0]] = min(rightRange[s[0]], num);
            leftRange[s[0]] = min(leftRange[s[0]], num);
        }
        for(set<char>::iterator it = candidates.begin(); it != candidates.end(); it++){
            if(leftRange[*it] == 10)
                leftRange[*it] = 0;
        }

        do{
            if(isPossibleDigits(digits, numPair, lenNum)){
                break;
            }
        }while(next_permutation(digits.begin(), digits.end()));

        for(int i =0 ; i< digits.size(); i++)
            digitsStr += digits[i];
        cout << "Case #" << ++tcn << ": " << digitsStr << "\n";
        rightRange.clear();
        leftRange.clear();
    }

}

int main(void){
    solve();
    return 0;
}