#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <tuple>
#include <limits>
#include <algorithm>
#include <unordered_map>
#include <math.h>
#include <random>

using namespace std;

#define NUMQ 10000

int numDigits(long long q) {
	int ret = 0;
	while (q > 0) {
		q /= 10;
		ret++;
	}
	return ret;
}

int main() {
	ifstream fin("randomize.in");
	int t;
	cin >> t;

	random_device rd;
	mt19937_64 eng(rd());

	for (int b = 1; b <= t; ++b) {
		int u;
		cin >> u;

		long long maxu = 1;
		for (int i = 0; i < u; i++)
			maxu *= 10;
		maxu--;
		uniform_int_distribution<long long> distr(0, maxu);

		unordered_map<char, int> charmap;
		vector<char> intmap(10);
		vector<vector<double>> probs(10, vector<double>(10, 0));
		int probspos = 0;
		for (int i = 0; i < NUMQ; ++i) {
			long long q;
			string r;
			cin >> q >> r;

			char curChar = r[0];

			for (char c : r) {
				if (charmap.find(c) == charmap.end()) {
					charmap[c] = probspos;
					intmap[probspos] = c;
					probspos++;
				}
			}

			bool wasNull  = false;
			if (q == -1) { // generate random q
				wasNull = true;
				q = maxu;
			}

			int idx = charmap[curChar];
			// front digit can't be 0
			probs[idx][0] = -1;

			int numDig = numDigits(q);
			if (numDig == r.length()) { 
				// take a look at first digit
				long long modVal = 1;
				for (int i = 0; i < numDig - 1; i++)
					modVal *= 10;

				int digit = q / modVal;

				for (int i = digit + 1; i < 10; ++i) { // all of these values are now impossible
					probs[idx][i] = -1;
				}
				
				for (int i = 1; i <= digit; ++i) {
					if (probs[idx][i] != -1) { // if has not been disabled
						if (i == digit) { // special case, last one
							probs[idx][i] += (double)(q % modVal) / q;
						}
						else {
							probs[idx][i] += (double)(modVal) / q;
						}
					}
				}
			}
			else if (numDig > r.length()) {
				vector<bool> appeared(10);
				for (char c : r) {
					int mappedInt = charmap[c];
					appeared[mappedInt] = true;
				}

				int numLeftover = 0;
				for (int i = 0; i < 10; ++i) {
					if (!appeared[i]) {
						numLeftover++;
					}
				}

				if (numLeftover == 1) {
					for (int i = 0; i < 10; ++i) {
						if (!appeared[i] && probs[i][0] != -1) {
							probs[i][0] += 1000000;
							break;
						}
					}
				}
				else if (numLeftover != 0) {
					for (int i = 0; i < 10; ++i) {
						if (!appeared[i] && probs[i][0] != -1) {
							probs[i][0] += (double)(1) / numLeftover;
						}
					}
				}
			}
		}

		string ret = "..........";

		vector<bool> used(10);
		
		for (int i = 0; i < 10; ++i) { // for every digit
			double bestVal = 0;
			int best = 0;
			for (int j = 0; j < 10; ++j) { // for every possible char
				if (!used[j]) {
					if (probs[j][i] > bestVal) {
						bestVal = probs[j][i];
						best = j;
					}
				}
			}

			ret[i] = intmap[best];
			used[best] = true;
		}

		cout << "Case #" << b << ": " << ret << "\n";
	}
	return 0;
}